#pragma once

#include <cerrno>
#include <cstdarg>

#include <base-rs.hpp>

extern int (*cpp_logger)(LogLevel level, const char *fmt, va_list ap);

void LOGD(const char *fmt, ...) __printflike(1, 2);
void LOGI(const char *fmt, ...) __printflike(1, 2);
void LOGW(const char *fmt, ...) __printflike(1, 2);
void LOGE(const char *fmt, ...) __printflike(1, 2);
#define PLOGE(fmt, args...) LOGE(fmt " failed with %d: %s\n", ##args, errno, std::strerror(errno))
