# Contributing to Buck2 Prelude

This repository is a subset of <https://github.com/facebook/buck2>.
You can contribute to either that repo, or this repo - changes will be mirrored to both.

We want to make contributing to this project as easy and transparent as possible.

## Our Development Process

Buck2 Prelude is currently developed in Facebook's internal repositories and then exported
out to GitHub by a Facebook team member; however, we invite you to submit pull
requests as described below.

## Pull Requests

We actively welcome your pull requests.

1. Fork the repo and create your branch from `main`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the test suite passes.
5. Make sure your code lints.
6. If you haven't already, complete the Contributor License Agreement ("CLA").

## Contributor License Agreement ("CLA")

In order to accept your pull request, we need you to submit a CLA. You only need
to do this once to work on any of Facebook's open source projects.

Complete your CLA here: <https://code.facebook.com/cla>

## Issues

We use GitHub issues to track public bugs. Please ensure your description is
clear and has sufficient instructions to be able to reproduce the issue.

Facebook has a [bounty program](https://www.facebook.com/whitehat/) for the safe
disclosure of security bugs. In those cases, please go through the process
outlined on that page and do not file a public issue.

## Coding Style

We use several Python formatters.

## License

By contributing to Buck2 Prelude, you agree that your contributions will be
licensed under both the [LICENSE-MIT](LICENSE-MIT) and [LICENSE-APACHE](LICENSE-APACHE)
files in the root directory of this source tree.
