# Copyright (c) Meta Platforms, Inc. and affiliates.
#
# This source code is licensed under both the MIT license found in the
# LICENSE-MIT file in the root directory of this source tree and the Apache
# License, Version 2.0 found in the LICENSE-APACHE file in the root directory
# of this source tree.

# TODO(cjhopman): This was generated by scripts/hacks/rules_shim_with_docs.py,
# but should be manually edited going forward. There may be some errors in
# the generated docs, and so those should be verified to be accurate and
# well-formatted (and then delete this TODO)

def _manifest_apk_arg():
    return {
        "manifest": attrs.option(attrs.source(), default = None, doc = """
    Relative path to the Android manifest for the APK. The common
     case is that the manifest will be in the same directory as the
     rule, in which case this will simply be
     `'AndroidManifest.xml'`, but it can also reference
     an `android\\_manifest()`rule.

     Prefer using `manifest_skeleton`, which performs merging automatically.
     Exactly one of `manifest` and `manifest_skeleton` must be set.
"""),
        "manifest_skeleton": attrs.option(attrs.source(), default = None, doc = """
    Relative path to the skeleton Android manifest for the APK.
     An `android\\_manifest()`will be created automatically to merge
     all manifests from libraries and resources going into the app.
     The common case is that the manifest will be in the same directory as the
     rule, in which case this will simply be
     `'AndroidManifest.xml'`.

     Exactly one of `manifest` and `manifest_skeleton` must be set.
"""),
    }

def _deps_apk_arg():
    return {
        "deps": attrs.list(attrs.dep(), default = [], doc = """
    List of build targets whose corresponding compiled Java code,
     Android resources, and native libraries will be included in the APK.
     From the transitive closure of these dependencies, the outputs of rules of the following type will be included in the APK:
     * `android_library()`* `android_resource()`* `cxx_library()`* `groovy_library()`* `java_library()`* `java_binary()`* `prebuilt_jar()`* `ndk_library()`* `prebuilt_native_library()`
"""),
    }

def _manifest_arg():
    return {
        "manifest": attrs.option(attrs.source(), default = None, doc = """
    An optional [Android Manifest](http://developer.android.com/guide/topics/manifest/manifest-intro.html) for the to declare any permissions or intents it may need or want to handle. May either be a file or a `android\\_manifest()`target.
"""),
    }

android_common = struct(
    manifest_apk_arg = _manifest_apk_arg,
    deps_apk_arg = _deps_apk_arg,
    manifest_arg = _manifest_arg,
)
