# Copyright (c) Meta Platforms, Inc. and affiliates.
#
# This source code is licensed under both the MIT license found in the
# LICENSE-MIT file in the root directory of this source tree and the Apache
# License, Version 2.0 found in the LICENSE-APACHE file in the root directory
# of this source tree.

# TODO(cjhopman): This was generated by scripts/hacks/rules_shim_with_docs.py,
# but should be manually edited going forward. There may be some errors in
# the generated docs, and so those should be verified to be accurate and
# well-formatted (and then delete this TODO)

load(":android_common.bzl", "android_common")
load(":common.bzl", "AbiGenerationMode", "AnnotationProcessingTool", "ForkMode", "LogLevel", "OnDuplicateEntry", "SourceAbiVerificationMode", "TestType", "UnusedDependenciesAction", "buck", "prelude_rule")
load(":genrule_common.bzl", "genrule_common")
load(":jvm_common.bzl", "jvm_common")

AaptMode = ["aapt1", "aapt2"]

CompressionAlgorithm = ["xz", "zstd"]

DexStore = ["raw", "jar", "xz", "xzs"]

DuplicateResourceBehaviour = ["allow_by_default", "ban_by_default"]

ExopackageMode = ["secondary_dex", "native_library", "resources", "modules", "arch64"]

JvmLanguage = ["java", "kotlin", "scala"]

PackageType = ["debug", "instrumented", "release", "test"]

RType = ["anim", "animator", "array", "attr", "bool", "color", "dimen", "drawable", "fraction", "font", "id", "integer", "interpolator", "layout", "menu", "navigation", "mipmap", "plurals", "raw", "string", "style", "styleable", "transition", "xml"]

ResourceCompressionMode = ["disabled", "enabled", "enabled_strings_only", "enabled_with_strings_as_assets"]

SdkProguardType = ["default", "optimized", "none"]

TargetCpuType = ["arm", "armv7", "arm64", "x86", "x86_64", "mips"]

android_aar = prelude_rule(
    name = "android_aar",
    docs = """
        An `android_aar()` rule is used to generate an Android AAR.


        See the [official Android documentation](https://developer.android.com/studio/projects/android-library#aar-contents) for details about the `.aar` format.
    """,
    examples = """
        ```

        android_resource(
          name = 'res',
          res = 'res',
          assets = 'assets',
          package = 'com.example',
        )

        android_library(
          name = 'lib',
          srcs = glob(['**/*.java']),
        )

        android_aar(
          name = 'app',
          manifest_skeleton = 'AndroidManifestSkeleton.xml',
          deps = [
            ':res',
            ':lib',
          ],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "manifest_skeleton": attrs.source(doc = """
                The skeleton manifest file used to generate the final `AndroidManifest.xml` . May either be a file or a `android\\_manifest()`target.
            """),
            "build_config_values": attrs.list(attrs.string(), default = [], doc = """
                See the documentation on the values argument for `android\\_build\\_config()`.
            """),
            "include_build_config_class": attrs.bool(default = False, doc = """
                Whether to include the `BuildConfig` class files in the final .aar file. Needs
                 to be set to `True` if any build\\_config\\_values are specified.
                 This is normally only needed if the build tool that is consuming the .aar file does not generate
                 `BuildConfig` classes.
                 Note: the AAR format does not specify a way to pass defaults that should be injected into
                 the final `BuildConfig` class, therefore that information might need to be replicated
                 manually in the build that's consuming the .aar file.
            """),
            "deps": attrs.list(attrs.dep(), default = [], doc = """
                List of build targets whose corresponding compiled Java code,
                 Android resources, and native libraries will be included in the AAR along with their transitive
                 dependencies. For compile time deps which should not be included in the final AAR,
                 use `provided_deps` instead.
                 * `android_library()` Will be included in the final `classes.jar`* `android_resource()` Will be included in the final `R.txt`,
                 `res/` and `assets/`* `android_build_config()` Will be included in the final `classes.jar`
                 if `include_build_config_class` is True
                 * `groovy_library()` Will be included in the final `classes.jar`* `java_library()` Will be included in the final `classes.jar`* `prebuilt_jar()` Will be included in the final `classes.jar`* `ndk_library()` Will be included in the final `jni/` or
                 `assets/` if `is_asset` is True
                 * `prebuilt_native_library()` Will be included in the final `jni/` or
                 `assets/` if `is_asset` is True
            """),
            "remove_classes": attrs.list(attrs.regex(), default = [], doc = """
                List of classes to remove from the output aar. It removes classes from the target's own sources,
                 and its dependencies.
            """),
            "abi_generation_mode": attrs.option(attrs.enum(AbiGenerationMode), default = None),
            "annotation_processing_tool": attrs.option(attrs.enum(AnnotationProcessingTool), default = None),
            "annotation_processor_deps": attrs.list(attrs.dep(), default = []),
            "annotation_processor_params": attrs.list(attrs.string(), default = []),
            "annotation_processors": attrs.list(attrs.string(), default = []),
            "build_config_values_file": attrs.option(attrs.source(), default = None),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "deps_query": attrs.option(attrs.query(), default = None),
            "enable_relinker": attrs.bool(default = False),
            "exported_deps": attrs.list(attrs.dep(), default = []),
            "exported_provided_deps": attrs.list(attrs.dep(), default = []),
            "extra_arguments": attrs.list(attrs.string(), default = []),
            "extra_kotlinc_arguments": attrs.list(attrs.string(), default = []),
            "extra_non_source_only_abi_kotlinc_arguments": attrs.list(attrs.string(), default = []),
            "friend_paths": attrs.list(attrs.dep(), default = []),
            "java_version": attrs.option(attrs.string(), default = None),
            "javac": attrs.option(attrs.source(), default = None),
            "kotlin_compiler_plugins": attrs.dict(key = attrs.source(), value = attrs.dict(key = attrs.string(), value = attrs.string(), sorted = False), sorted = False, default = {}),
            "labels": attrs.list(attrs.string(), default = []),
            "language": attrs.option(attrs.enum(JvmLanguage), default = None),
            "licenses": attrs.list(attrs.source(), default = []),
            "manifest": attrs.option(attrs.source(), default = None),
            "manifest_file": attrs.option(attrs.source(), default = None),
            "maven_coords": attrs.option(attrs.string(), default = None),
            "native_library_merge_code_generator": attrs.option(attrs.dep(), default = None),
            "native_library_merge_glue": attrs.option(attrs.dep(), default = None),
            "native_library_merge_localized_symbols": attrs.option(attrs.set(attrs.string(), sorted = True), default = None),
            "native_library_merge_map": attrs.option(attrs.dict(key = attrs.string(), value = attrs.list(attrs.regex()), sorted = False), default = None),
            "native_library_merge_sequence": attrs.option(attrs.list(attrs.tuple(attrs.string(), attrs.list(attrs.regex()))), default = None),
            "native_library_merge_sequence_blocklist": attrs.option(attrs.list(attrs.regex()), default = None),
            "never_mark_as_unused_dependency": attrs.option(attrs.bool(), default = None),
            "on_unused_dependencies": attrs.option(attrs.enum(UnusedDependenciesAction), default = None),
            "plugins": attrs.list(attrs.dep(), default = []),
            "proguard_config": attrs.option(attrs.source(), default = None),
            "provided_deps": attrs.list(attrs.dep(), default = []),
            "provided_deps_query": attrs.option(attrs.query(), default = None),
            "relinker_whitelist": attrs.list(attrs.regex(), default = []),
            "required_for_source_only_abi": attrs.bool(default = False),
            "resource_union_package": attrs.option(attrs.string(), default = None),
            "resources": attrs.list(attrs.source(), default = []),
            "resources_root": attrs.option(attrs.source(), default = None),
            "runtime_deps": attrs.list(attrs.dep(), default = []),
            "source": attrs.option(attrs.string(), default = None),
            "source_abi_verification_mode": attrs.option(attrs.enum(SourceAbiVerificationMode), default = None),
            "source_only_abi_deps": attrs.list(attrs.dep(), default = []),
            "srcs": attrs.list(attrs.source(), default = []),
            "target": attrs.option(attrs.string(), default = None),
            "use_jvm_abi_gen": attrs.option(attrs.bool(), default = None),
        }
    ),
)

android_app_modularity = prelude_rule(
    name = "android_app_modularity",
    docs = "",
    examples = None,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "application_module_blacklist": attrs.option(attrs.list(attrs.query()), default = None),
            "application_module_configs": attrs.dict(key = attrs.string(), value = attrs.list(attrs.dep()), sorted = False, default = {}),
            "application_module_dependencies": attrs.option(attrs.dict(key = attrs.string(), value = attrs.list(attrs.string()), sorted = False), default = None),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "deps": attrs.list(attrs.dep(), default = []),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "no_dx": attrs.list(attrs.dep(), default = []),
            "should_include_classes": attrs.bool(default = True),
            "should_include_libraries": attrs.bool(default = False),
        }
    ),
)

android_binary = prelude_rule(
    name = "android_binary",
    docs = "",
    examples = None,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "aapt2_keep_raw_values": attrs.bool(default = False),
            "aapt2_locale_filtering": attrs.bool(default = False),
            "aapt_mode": attrs.enum(AaptMode, default = "aapt1"),
            "additional_aapt_params": attrs.list(attrs.string(), default = []),
            "allow_r_dot_java_in_secondary_dex": attrs.bool(default = False),
            "allowed_duplicate_resource_types": attrs.list(attrs.enum(RType), default = []),
            "android_sdk_proguard_config": attrs.option(attrs.enum(SdkProguardType), default = None),
            "application_module_blacklist": attrs.option(attrs.list(attrs.query()), default = None),
            "application_module_configs": attrs.dict(key = attrs.string(), value = attrs.list(attrs.dep()), sorted = False, default = {}),
            "application_module_dependencies": attrs.option(attrs.dict(key = attrs.string(), value = attrs.list(attrs.string()), sorted = False), default = None),
            "asset_compression_algorithm": attrs.option(attrs.enum(CompressionAlgorithm), default = None),
            "banned_duplicate_resource_types": attrs.list(attrs.enum(RType), default = []),
            "build_config_values": attrs.list(attrs.string(), default = []),
            "build_config_values_file": attrs.option(attrs.source(), default = None),
            "build_string_source_map": attrs.bool(default = False),
            "compress_asset_libraries": attrs.bool(default = False),
            "contacts": attrs.list(attrs.string(), default = []),
            "cpu_filters": attrs.list(attrs.enum(TargetCpuType), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "deps": attrs.list(attrs.dep(), default = []),
            "dex_compression": attrs.option(attrs.enum(DexStore), default = None),
            "dex_group_lib_limit": attrs.int(default = 0),
            "dex_tool": attrs.string(default = ""),
            "disable_pre_dex": attrs.bool(default = False),
            "duplicate_resource_behavior": attrs.enum(DuplicateResourceBehaviour, default = "allow_by_default"),
            "duplicate_resource_whitelist": attrs.option(attrs.source(), default = None),
            "enable_relinker": attrs.bool(default = False),
            "exopackage_modes": attrs.list(attrs.enum(ExopackageMode), default = []),
            "extra_filtered_resources": attrs.list(attrs.string(), default = []),
            "field_ref_count_buffer_space": attrs.int(default = 0),
            "ignore_aapt_proguard_config": attrs.bool(default = False),
            "includes_vector_drawables": attrs.bool(default = False),
            "is_cacheable": attrs.bool(default = False),
            "is_voltron_language_pack_enabled": attrs.bool(default = False),
            "keystore": attrs.dep(),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "linear_alloc_hard_limit": attrs.int(default = 4194304),
            "locales": attrs.list(attrs.string(), default = []),
            "manifest": attrs.option(attrs.source(), default = None),
            "manifest_entries": attrs.dict(key = attrs.string(), value = attrs.any(), default = {}),
            "manifest_skeleton": attrs.option(attrs.source(), default = None),
            "method_ref_count_buffer_space": attrs.int(default = 0),
            "minimize_primary_dex_size": attrs.bool(default = False),
            "module_manifest_skeleton": attrs.option(attrs.source(), default = None),
            "native_library_merge_code_generator": attrs.option(attrs.dep(), default = None),
            "native_library_merge_glue": attrs.option(attrs.dep(), default = None),
            "native_library_merge_localized_symbols": attrs.option(attrs.set(attrs.string(), sorted = True), default = None),
            "native_library_merge_map": attrs.option(attrs.dict(key = attrs.string(), value = attrs.list(attrs.regex()), sorted = False), default = None),
            "native_library_merge_sequence": attrs.option(attrs.list(attrs.tuple(attrs.string(), attrs.list(attrs.regex()))), default = None),
            "native_library_merge_sequence_blocklist": attrs.option(attrs.list(attrs.regex()), default = None),
            "no_auto_add_overlay_resources": attrs.bool(default = False),
            "no_auto_version_resources": attrs.bool(default = False),
            "no_dx": attrs.list(attrs.dep(), default = []),
            "no_version_transitions_resources": attrs.bool(default = False),
            "optimization_passes": attrs.int(default = 1),
            "package_asset_libraries": attrs.bool(default = False),
            "package_type": attrs.enum(PackageType, default = "debug"),
            "packaged_locales": attrs.list(attrs.string(), default = []),
            "post_filter_resources_cmd": attrs.option(attrs.arg(), default = None),
            "preprocess_java_classes_bash": attrs.option(attrs.arg(), default = None),
            "preprocess_java_classes_cmd": attrs.option(attrs.arg(), default = None),
            "preprocess_java_classes_deps": attrs.list(attrs.dep(), default = []),
            "primary_dex_patterns": attrs.list(attrs.string(), default = []),
            "proguard_config": attrs.option(attrs.source(), default = None),
            "proguard_jvm_args": attrs.list(attrs.string(), default = []),
            "relinker_whitelist": attrs.list(attrs.regex(), default = []),
            "resource_compression": attrs.enum(ResourceCompressionMode, default = "disabled"),
            "resource_filter": attrs.list(attrs.string(), default = []),
            "resource_stable_ids": attrs.option(attrs.source(), default = None),
            "resource_union_package": attrs.option(attrs.string(), default = None),
            "secondary_dex_weight_limit": attrs.option(attrs.int(), default = None),
            "skip_crunch_pngs": attrs.option(attrs.bool(), default = None),
            "skip_proguard": attrs.bool(default = False),
            "trim_resource_ids": attrs.bool(default = False),
            "use_split_dex": attrs.bool(default = False),
            "xz_compression_level": attrs.int(default = 4),
        }
    ),
)

android_build_config = prelude_rule(
    name = "android_build_config",
    docs = """
        An `android_build_config()` rule is used to generate
        a `BuildConfig` class with global configuration variables
        that other `android\\_library()`rules can compile against.
        Currently, the only variable exposed by `BuildConfig` is
        a global `boolean` named `DEBUG`, much like
        the `BuildConfig.java` generated by the official Android
        build tools based on Gradle.


        The fields in the generated `BuildConfig` class will
        be non-constant-expressions (see [JLS 15.28](http://docs.oracle.com/javase/specs/jls/se7/html/jls-15.html#jls-15.28)).
        However, if `BuildConfig` is packaged into an APK, it will
        be replaced with a new version where:
        * The fields will be set to literal values (i.e., constant expressions).
         * The `boolean BuildConfig.DEBUG` field will correspond to
        that of the `package_type` argument to the `android\\_binary()`rule
        that is packaging it.


        This transformation is done before ProGuard is applied (if applicable), so
        that it can propagate constants from `BuildConfig` and eliminate
        dead code.
    """,
    examples = """
        Here is an example of an `android_build_config()` rule that
        is transitively included by both *debug* and *release* versions
        of an `android\\_binary()`rule. The value
        of `com.example.pkg.BuildConfig.DEBUG` will be different in each APK
        even though they both transitively depend on the same `:build_config` rule.


        ```

        android_build_config(
          name = 'build_config',
          package = 'com.example.pkg',
          values = [
            'String COMMIT_ID = "0000000000000000000000000000000000000000"',
          ],
        )

        # The .java files in this library may contain references to the boolean
        # com.example.pkg.BuildConfig.DEBUG because :build_config is in the deps.
        # It could also reference BuildConfig.COMMIT_ID.
        android_library(
          name = 'mylib',
          srcs = glob(['src/**/*.java']),
          deps = [
            ':build_config',
          ],
        )

        android_binary(
          name = 'debug',
          package_type = 'DEBUG',
          keystore =  '//keystores:debug',
          manifest = 'AndroidManifest.xml',
          target = 'Google Inc.:Google APIs:19',
          deps = [
            ':mylib',
          ],
        )

        # The contents of the file generated by this rule might be:
        #
        # String COMMIT_ID = "7bf804bdf71fdbfc99cce3b155b3643f022c6fa4"
        #
        # Note that the output of :build_config_release_values will be cached by Buck.
        # Assuming that generate_release_build_config.py depends on state that is not
        # expressed by its deps (which violates a fundamental invariant in Buck!), a
        # workaround is to ensure that the inputs to :build_config_release_values are
        # changed in some way before :release is built to ensure that the output from
        # :build_config_release_values is not pulled from cache. For example:
        #
        # $ buck build :release
        # $ uuidgen > dummy_state_file.txt
        # $ buck build :release
        #
        # This makes sure that generate_release_build_config.py is re-run before
        # :release is rebuilt. This is much cheaper than deleting your build cache
        # before rebuilding.
        genrule(
          name = 'build_config_release_values',
          srcs = [ 'generate_release_build_config.py', 'dummy_state_file.txt' ],
          bash = 'generate_release_build_config.py $OUT',
          out = 'build_config_release_values.txt',
        )

        android_binary(
          name = 'release',
          package_type = 'RELEASE',
          keystore =  '//keystores:release',
          manifest = 'AndroidManifest.xml',
          target = 'Google Inc.:Google APIs:19',
          build_config_values_file = ':build_config_release_values',
          deps = [
            ':mylib',
          ],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "package": attrs.string(default = "", doc = """
                Name of the Java package to use in the generated `BuildConfig.java` file.
                 Most developers set this to the application id declared in the manifest
                 via `<manifest package="APP_ID">`.
                 Example: `com.facebook.orca`.
            """),
            "values": attrs.list(attrs.string(), default = [], doc = """
                List of strings that defines additional fields (and values) that should be declared in the
                 generated `BuildConfig.java` file. Like `DEBUG`, the values will be
                 non-constant-expressions that evaluate to the value specified in the file at compilation
                 time.
                 To override the values in an APK, specify build\\_config\\_values or build\\_config\\_values\\_file in `android\\_binary()`.
            """),
            "values_file": attrs.option(attrs.source(), default = None, doc = """
                Optional path to a file that defines additional fields (and values) that should be declared in the
                 generated `BuildConfig.java` file. Like `DEBUG`, the values will be
                 non-constant-expressions that evaluate to the value specified in the file at compilation
                 time.
                 To override the values in an APK, specify build\\_config\\_values or build\\_config\\_values\\_file in `android\\_binary()`.

                 Note that values\\_file can be a generated file, as can build\\_config\\_values\\_file as
                 demonstrated in the example below.
            """),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
        }
    ),
)

android_bundle = prelude_rule(
    name = "android_bundle",
    docs = "",
    examples = None,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "aapt2_keep_raw_values": attrs.bool(default = False),
            "aapt2_locale_filtering": attrs.bool(default = False),
            "aapt_mode": attrs.enum(AaptMode, default = "aapt1"),
            "additional_aapt_params": attrs.list(attrs.string(), default = []),
            "allow_r_dot_java_in_secondary_dex": attrs.bool(default = False),
            "allowed_duplicate_resource_types": attrs.list(attrs.enum(RType), default = []),
            "android_sdk_proguard_config": attrs.option(attrs.enum(SdkProguardType), default = None),
            "application_module_blacklist": attrs.option(attrs.list(attrs.query()), default = None),
            "application_module_configs": attrs.dict(key = attrs.string(), value = attrs.list(attrs.dep()), sorted = False, default = {}),
            "application_module_dependencies": attrs.option(attrs.dict(key = attrs.string(), value = attrs.list(attrs.string()), sorted = False), default = None),
            "asset_compression_algorithm": attrs.option(attrs.enum(CompressionAlgorithm), default = None),
            "banned_duplicate_resource_types": attrs.list(attrs.enum(RType), default = []),
            "build_config_values": attrs.list(attrs.string(), default = []),
            "build_config_values_file": attrs.option(attrs.source(), default = None),
            "build_string_source_map": attrs.bool(default = False),
            "bundle_config_file": attrs.option(attrs.source(), default = None),
            "compress_asset_libraries": attrs.bool(default = False),
            "contacts": attrs.list(attrs.string(), default = []),
            "cpu_filters": attrs.list(attrs.enum(TargetCpuType), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "deps": attrs.list(attrs.dep(), default = []),
            "dex_compression": attrs.option(attrs.enum(DexStore), default = None),
            "dex_group_lib_limit": attrs.int(default = 0),
            "dex_tool": attrs.string(default = ""),
            "disable_pre_dex": attrs.bool(default = False),
            "duplicate_resource_behavior": attrs.enum(DuplicateResourceBehaviour, default = "allow_by_default"),
            "duplicate_resource_whitelist": attrs.option(attrs.source(), default = None),
            "enable_relinker": attrs.bool(default = False),
            "exopackage_modes": attrs.list(attrs.enum(ExopackageMode), default = []),
            "extra_filtered_resources": attrs.list(attrs.string(), default = []),
            "field_ref_count_buffer_space": attrs.int(default = 0),
            "ignore_aapt_proguard_config": attrs.bool(default = False),
            "includes_vector_drawables": attrs.bool(default = False),
            "is_cacheable": attrs.bool(default = False),
            "is_voltron_language_pack_enabled": attrs.bool(default = False),
            "keystore": attrs.dep(),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "linear_alloc_hard_limit": attrs.int(default = 4194304),
            "locales": attrs.list(attrs.string(), default = []),
            "manifest": attrs.option(attrs.source(), default = None),
            "manifest_entries": attrs.dict(key = attrs.string(), value = attrs.any(), default = {}),
            "manifest_skeleton": attrs.option(attrs.source(), default = None),
            "method_ref_count_buffer_space": attrs.int(default = 0),
            "minimize_primary_dex_size": attrs.bool(default = False),
            "module_manifest_skeleton": attrs.option(attrs.source(), default = None),
            "native_library_merge_code_generator": attrs.option(attrs.dep(), default = None),
            "native_library_merge_glue": attrs.option(attrs.dep(), default = None),
            "native_library_merge_localized_symbols": attrs.option(attrs.set(attrs.string(), sorted = True), default = None),
            "native_library_merge_map": attrs.option(attrs.dict(key = attrs.string(), value = attrs.list(attrs.regex()), sorted = False), default = None),
            "native_library_merge_sequence": attrs.option(attrs.list(attrs.tuple(attrs.string(), attrs.list(attrs.regex()))), default = None),
            "native_library_merge_sequence_blocklist": attrs.option(attrs.list(attrs.regex()), default = None),
            "no_auto_add_overlay_resources": attrs.bool(default = False),
            "no_auto_version_resources": attrs.bool(default = False),
            "no_dx": attrs.list(attrs.dep(), default = []),
            "no_version_transitions_resources": attrs.bool(default = False),
            "optimization_passes": attrs.int(default = 1),
            "package_asset_libraries": attrs.bool(default = False),
            "package_type": attrs.enum(PackageType, default = "debug"),
            "packaged_locales": attrs.list(attrs.string(), default = []),
            "post_filter_resources_cmd": attrs.option(attrs.arg(), default = None),
            "preprocess_java_classes_bash": attrs.option(attrs.arg(), default = None),
            "preprocess_java_classes_cmd": attrs.option(attrs.arg(), default = None),
            "preprocess_java_classes_deps": attrs.list(attrs.dep(), default = []),
            "primary_dex_patterns": attrs.list(attrs.string(), default = []),
            "proguard_config": attrs.option(attrs.source(), default = None),
            "proguard_jvm_args": attrs.list(attrs.string(), default = []),
            "relinker_whitelist": attrs.list(attrs.regex(), default = []),
            "resource_compression": attrs.enum(ResourceCompressionMode, default = "disabled"),
            "resource_filter": attrs.list(attrs.string(), default = []),
            "resource_stable_ids": attrs.option(attrs.source(), default = None),
            "resource_union_package": attrs.option(attrs.string(), default = None),
            "secondary_dex_weight_limit": attrs.option(attrs.int(), default = None),
            "skip_crunch_pngs": attrs.option(attrs.bool(), default = None),
            "skip_proguard": attrs.bool(default = False),
            "trim_resource_ids": attrs.bool(default = False),
            "use_split_dex": attrs.bool(default = False),
            "xz_compression_level": attrs.int(default = 4),
        }
    ),
)

android_instrumentation_apk = prelude_rule(
    name = "android_instrumentation_apk",
    docs = """
        An `android_instrumentation_apk()` rule is used to generate
        an Android Instrumentation APK.


        Android's [Testing Fundamentals](http://developer.android.com/tools/testing/testing_android.html) documentation includes a diagram that shows
        the relationship between an "application package" and a "test package"
        when running a test. This rule corresponds to a test package. Note
        that a test package has an interesting quirk where it is *compiled
        against* an application package, but *must not include* the
        resources or Java classes of the application package. Therefore, this
        class takes responsibility for making sure the appropriate bits are
        excluded. Failing to do so will generate mysterious runtime errors
        when running the test.
    """,
    examples = """
        Here is an example of an `android_instrumentation_apk()` rule that tests a `android_binary()`, and depends on a test
        package.


        ```

        android_library(
          name = 'test',
          srcs = glob(['test/**/*.java']),
        )

        android_binary(
          name = 'messenger',
          manifest = 'AndroidManifest.xml',
          keystore = '//keystores:prod',
          package_type = 'release',
          proguard_config = 'proguard.cfg',
          deps = [
            ...
          ],
        )

        # Building this rule will produce a file named messenger_test.apk
        android_instrumentation_apk(
          name = 'messenger_test',
          manifest = 'AndroidInstrumentationManifest.xml',
          apk = ':messenger',
          deps = [
            ':test',
          ],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        android_common.manifest_apk_arg() |
        {
            "apk": attrs.dep(doc = """
                APK build target, which should be used for the instrumentation APK.
                 Can be either a `android\\_binary()`or a
                 `apk\\_genrule()`.
            """),
        } |
        android_common.deps_apk_arg() |
        {
            "aapt_mode": attrs.enum(AaptMode, default = "aapt1"),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "dex_tool": attrs.string(default = ""),
            "disable_pre_dex": attrs.bool(default = False),
            "includes_vector_drawables": attrs.bool(default = False),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "use_split_dex": attrs.option(attrs.bool(), default = None),
            "primary_dex_patterns": attrs.list(attrs.string(), default = []),
        }
    ),
)

android_instrumentation_test = prelude_rule(
    name = "android_instrumentation_test",
    docs = """
        A `android_instrumentation_test()` rule is used to define
         apks that should be used to run Android instrumentation tests.
    """,
    examples = """
        Here is an example of an `android_instrumentation_test()`
         rule that tests an `android_binary()`.


        ```

        android_binary(
          name = 'messenger',
          manifest = 'AndroidManifest.xml',
          keystore = '//keystores:prod',
          package_type = 'release',
          proguard_config = 'proguard.cfg',
          deps = [
            ...
          ],
        )

        android_instrumentation_apk(
          name = 'messenger_test',
          manifest = 'AndroidInstrumentationManifest.xml',
          apk = ':messenger',
          deps = [
            ...
          ],
        )

        android_instrumentation_test(
          name = 'messenger_instrumentation_test',
          apk = ':messenger_test',
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "apk": attrs.dep(doc = """
                The APK containing the tests. Can be an `android\\_binary()`,
                 an `apk\\_genrule()`or an `android\\_instrumentation\\_apk()`.
            """),
        } |
        buck.test_label_arg() |
        buck.test_rule_timeout_ms() |
        {
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "env": attrs.dict(key = attrs.string(), value = attrs.arg(), sorted = False, default = {}),
            "licenses": attrs.list(attrs.source(), default = []),
        }
    ),
)

android_library = prelude_rule(
    name = "android_library",
    docs = """
        An `android_library()` rule is used to define a set of Java files
        that can be compiled together against the Android SDK. The main output of an
         `android_library()` rule is a single JAR file containing all of the
        compiled class files and resources.
    """,
    examples = """
        An `android_library` rule used in concert with an
         `android\\_resource()`rule.
        This would be a common arrangement for a standard Android Library project
        as defined by
         <http://developer.android.com/tools/projects/index.html>

        ```

        android_resource(
          name = 'res',
          res = 'res',
          package = 'com.example',
        )

        android_library(
          name = 'my_library',
          srcs = glob(['src/**/*.java']),
          deps = [
            ':res',
          ],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "srcs": attrs.list(attrs.source(), default = [], doc = """
                The set of `.java` files to compile for this rule.
            """),
            "resources": attrs.list(attrs.source(), default = [], doc = """
                Static files to include among the compiled `.class`
                 files. These files can be loaded via [Class.getResource()](http://docs.oracle.com/javase/7/docs/api/java/lang/Class.html#getResource(java.lang.String)).

                **Note:** Buck uses the `src_roots` property in
                 `.buckconfig`
                 to help determine where resources should be placed within the generated JAR file.
            """),
        } |
        android_common.manifest_arg() |
        {
            "deps": attrs.list(attrs.dep(), default = [], doc = """
                Rules (usually other `android_library` rules)
                 that are used to generate the classpath required to compile this
                 `android_library`.
            """),
            "source": attrs.option(attrs.string(), default = None, doc = """
                Specifies the version of Java (as a string) to interpret source
                 files as.
                 Overrides the value in "source\\_level" in the "java" section
                 of `.buckconfig`.
            """),
            "target": attrs.option(attrs.string(), default = None, doc = """
                Specifies the version of Java (as a string) for which to
                 generate code.
                 Overrides the value in "target\\_level" in the "java" section
                 of `.buckconfig`.
            """),
            "javac": attrs.option(attrs.source(), default = None, doc = """
                Specifies the Java compiler program to use for this rule.
                 The value is a source path (e.g., //foo/bar:bar).
                 Overrides the value in "javac" in the "tools" section
                 of `.buckconfig`.
            """),
            "extra_arguments": attrs.list(attrs.string(), default = [], doc = """
                List of additional arguments to pass into the Java compiler. These
                 arguments follow the ones specified in `.buckconfig`.
            """),
            "extra_kotlinc_arguments": attrs.list(attrs.string(), default = [], doc = """
                List of additional arguments to pass into the Kotlin compiler.
            """),
            "annotation_processing_tool": attrs.option(attrs.enum(AnnotationProcessingTool), default = None, doc = """
                Specifies the tool to use for annotation processing. Possible values: "kapt" or "javac".
                 "kapt" allows running Java annotation processors against Kotlin sources while backporting
                 it for Java sources too.
                 "javac" works only against Java sources, Kotlin sources won't have access to generated
                 classes at compile time.
            """),
        } |
        jvm_common.exported_deps() |
        jvm_common.provided_deps() |
        jvm_common.exported_provided_deps() |
        buck.deps_query_arg() |
        buck.provided_deps_query_arg() |
        jvm_common.abi_generation_mode() |
        jvm_common.source_only_abi_deps() |
        jvm_common.required_for_source_only_abi() |
        {
            "remove_classes": attrs.list(attrs.regex(), default = [], doc = """
                List of classes to remove from the output jar. It only removes classes from the target's own
                 sources, not from any of its dependencies.
            """),
            "annotation_processor_deps": attrs.list(attrs.dep(), default = []),
            "annotation_processor_params": attrs.list(attrs.string(), default = []),
            "annotation_processors": attrs.list(attrs.string(), default = []),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "extra_non_source_only_abi_kotlinc_arguments": attrs.list(attrs.string(), default = []),
            "friend_paths": attrs.list(attrs.dep(), default = []),
            "java_version": attrs.option(attrs.string(), default = None),
            "kotlin_compiler_plugins": attrs.dict(key = attrs.source(), value = attrs.dict(key = attrs.string(), value = attrs.string(), sorted = False), sorted = False, default = {}),
            "labels": attrs.list(attrs.string(), default = []),
            "language": attrs.option(attrs.enum(JvmLanguage), default = None),
            "licenses": attrs.list(attrs.source(), default = []),
            "manifest_file": attrs.option(attrs.source(), default = None),
            "maven_coords": attrs.option(attrs.string(), default = None),
            "never_mark_as_unused_dependency": attrs.option(attrs.bool(), default = None),
            "on_unused_dependencies": attrs.option(attrs.enum(UnusedDependenciesAction), default = None),
            "plugins": attrs.list(attrs.dep(), default = []),
            "proguard_config": attrs.option(attrs.source(), default = None),
            "resource_union_package": attrs.option(attrs.string(), default = None),
            "resources_root": attrs.option(attrs.source(), default = None),
            "runtime_deps": attrs.list(attrs.dep(), default = []),
            "source_abi_verification_mode": attrs.option(attrs.enum(SourceAbiVerificationMode), default = None),
            "use_jvm_abi_gen": attrs.option(attrs.bool(), default = None),
        }
    ),
)

android_manifest = prelude_rule(
    name = "android_manifest",
    docs = """
        An `android_manifest()` rule is used to generate an
         [Android
        Manifest](http://developer.android.com/guide/topics/manifest/manifest-intro.html) to be used by `android\\_binary()`and `android\\_aar()`rules. This
        rule takes a skeleton manifest, and merges it with manifests found in any deps.
    """,
    examples = """
        Here's an example of an `android_manifest()` that has no deps.


        ```

        android_manifest(
          name = 'my-manifest',
          skeleton = 'AndroidManifestSkeleton.xml',
        )

        ```

         This is what `AndroidManifestSkeleton.xml` looks like.


        ```

        <?xml version="1.0" encoding="utf-8"?>
        <manifest xmlns:android="http://schemas.android.com/apk/res/android"
                  package="com.example"
                  android:versionCode="1"
                  android:versionName="1.0">

            <uses-sdk targetSdkVersion="19" minSdkVersion="17"/>
            <application
                android:label="@string/app_name"
                android:icon="@drawable/ic_launcher">
                <activity
                    android:name="MyActivity"
                    android:label="@string/app_name">
                    <intent-filter>
                        <action android:name="android.intent.action.MAIN"/>
                        <category android:name="android.intent.category.LAUNCHER"/>
                    </intent-filter>
                </activity>
            </application>
        </manifest>

        ```

         You could also use a `genrule()`to generate the manifest file and reference the
         `build target`in the `skeleton` argument.
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "skeleton": attrs.source(doc = """
                Either a `build target`or a path to a file representing the manifest that
                 will be merged with any manifests associated with this rule's `deps`.
            """),
            "deps": attrs.list(attrs.dep(), default = [], doc = """
                A collection of dependencies that includes android\\_library rules. The manifest files of the
                 `android\\_library()`rules will be filtered out to become dependent source files for
                 the manifest.
            """),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
        }
    ),
)

android_platform = prelude_rule(
    name = "android_platform",
    docs = "",
    examples = None,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "base_platform": attrs.configuration_label(),
            "native_platforms": attrs.dict(key = attrs.enum(TargetCpuType), value = attrs.configuration_label(), sorted = False, default = {}),
        }
    ),
)

android_prebuilt_aar = prelude_rule(
    name = "android_prebuilt_aar",
    docs = """
        An `android_prebuilt_aar()` rule takes an `.aar` file and
        makes it available as an Android dependency. As expected,
        an `android\\_binary()`that transitively depends on
        an `android_prebuilt_aar()` will include its contents in the generated APK.


        See the [official Android documentation](https://developer.android.com/studio/projects/android-library#aar-contents) for details about the `.aar` format.
    """,
    examples = """
        ```

        android_prebuilt_aar(
          name = 'play-services',
          aar = 'play-services-4.0.30.aar',
          source_jar = 'play-services-4.0.30-sources.jar',
          javadoc_url = 'file:///opt/android-sdk/extras/google/google_play_services/docs/reference',
        )

        android_library(
          name = 'lib',
          # This Java code can compile against Play services and reference its resources.
          srcs = glob(['*.java']),
          deps = [ ':play-services' ],
        )
        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "aar": attrs.source(doc = """
                Path to the `.aar` file. This may also be a build target to
                 a rule (such as a `genrule()`) whose output is
                 an `.aar` file.
            """),
            "source_jar": attrs.option(attrs.source(), default = None, doc = """
                Path to a JAR file that contains the `.java` files to create
                 the `.class` in the `aar`. This is frequently
                 provided for debugging purposes.
            """),
            "javadoc_url": attrs.option(attrs.string(), default = None, doc = """
                URL to the Javadoc for the `.class` files in the
                 `aar`.
            """),
            "use_system_library_loader": attrs.bool(default = False, doc = """
                If this `.aar` file contains native prebuilt `.so` libraries and the
                 Java code uses these libraries via a call to `System.loadLibrary()`, then many
                 optimizations—such as exopackage, compression, or asset packaging—may not be compatible with these prebuilt libs.
                 Setting this parameter to `True` causes all of these optimizations to skip the prebuilt `.so`
                 files originating from this `.aar` file. The `.so` files will always be packaged directly into
                 the main `.apk`.
            """),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "deps": attrs.list(attrs.dep(), default = []),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "maven_coords": attrs.option(attrs.string(), default = None),
            "required_for_source_only_abi": attrs.bool(default = False),
        }
    ),
)

android_resource = prelude_rule(
    name = "android_resource",
    docs = """
        An `android_resource()` rule is used to bundle Android resources
        that are traditionally stored in `res` and `assets` directories.

        The output of an `android_resource()` is an `R.txt` file
        generated via `aapt --output-text-symbols`.
    """,
    examples = """
        Most of the time, an `android_resource` rule defines only `name`, `res`, and `package`. By convention,
        such simple rules are often named `res`:


        ```

        android_resource(
          name = 'res',
          res = subdir_glob([('res', '**')]),
          package = 'com.example',
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "res": attrs.option(attrs.one_of(attrs.source(), attrs.dict(key = attrs.string(), value = attrs.source(), sorted = True)), default = None, doc = """
                A dictionary mapping relative resource paths to either
                 the resource files or the build targets that generate them.
                 The `subdir_glob` function
                 can be used to generate dictionaries based on a directory structure of files checked
                 into the repository. Alternatively, this can be a path to a directory containing
                 Android resources, although this option is deprecated and might be removed in the future.
            """),
            "package": attrs.option(attrs.string(), default = None, doc = """
                Java package for the `R.java` file that will be generated for these
                 resources.
            """),
            "assets": attrs.option(attrs.one_of(attrs.source(), attrs.dict(key = attrs.string(), value = attrs.source(), sorted = True)), default = None, doc = """
                A dictionary mapping relative asset paths to either
                 the asset files or the build targets that generate them.
                 The `subdir_glob` function
                 can be used to generate dictionaries based on a directory structure of files checked
                 into the repository. Alternatively, this can be a path to a directory containing
                 Android assets, although this option is deprecated and might be removed in the future.
            """),
            "project_res": attrs.option(attrs.source(), default = None, doc = """
                A directory containing resources to be used for project generation.
                 If not provided, defaults to whatever the build uses.
            """),
            "project_assets": attrs.option(attrs.source(), default = None, doc = """
                A directory containing assets to be used for project generation.
                 If not provided, defaults to whatever the build uses.
            """),
        } |
        android_common.manifest_arg() |
        {
            "deps": attrs.list(attrs.dep(), default = [], doc = """
                Other `android_resource` rules to include via `-S` when
                 running `aapt`.
            """),
            "allowlisted_locales": attrs.option(attrs.set(attrs.string(), sorted = False), default = None),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "has_whitelisted_strings": attrs.bool(default = False),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "resource_union": attrs.bool(default = False),
        }
    ),
)

apk_genrule = prelude_rule(
    name = "apk_genrule",
    docs = """
        An `apk_genrule()` rule is used to post-process an APK. What
        separates an apk\\_genrule from a genrule is apk\\_genrules are known by BUCK to
        produce APKs, so commands like `buck install` or
         `buck uninstall` still work. Additionally,
         `apk_genrule()` rules can be inputs to other
         `apk_genrule()` rules.
    """,
    examples = """
        Here is an example of a couple `apk_genrule()` open up an APK, do
        some super signing, and then zipalign that APK again.


        ```


        # Building this rule will produce a file named messenger.apk.
        android_binary(
          name = 'messenger',
          manifest = 'AndroidManifest.xml',
          target = 'Google Inc.:Google APIs:16',
          keystore = '//keystores:prod',
          package_type = 'release',
          proguard_config = 'proguard.cfg',
          deps = [
            ':res',
            ':src',
          ],
        )

        apk_genrule(
          name = 'messenger_super_sign_unalign',
          apk = ':messenger',
          bash = '$(exe //java/com/facebook/sign:super_sign) --input $APK --output $OUT',
          cmd_exe = '$(exe //java/com/facebook/sign:super_sign) --input %APK% --output %OUT%',
          out = 'messenger_super_sign_unalign.apk',
        )

        apk_genrule(
          name = 'messenger_super_sign',
          apk = ':messenger_super_sign_unalign',
          bash = '$ANDROID_HOME/tools/zipalign -f 4 $APK $OUT',
          cmd_exe = '%ANDROID_HOME%\\tools\\zipalign -f 4 %APK% %OUT%',
          out = 'messenger_super_sign.apk',
        )


        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "apk": attrs.option(attrs.dep(), default = None, doc = """
                The input `android_binary()` rule. The path to the APK can be
                 accessed with the `$APK` shell variable.
            """),
        } |
        genrule_common.srcs_arg() |
        genrule_common.cmd_arg() |
        genrule_common.bash_arg() |
        genrule_common.cmd_exe_arg() |
        genrule_common.type_arg() |
        {
            "out": attrs.option(attrs.string(), default = None, doc = """
                This argument only exists for historical reasons and it does not have any
                 effect. It will be deprecated and removed in the future.
            """),
        } |
        genrule_common.environment_expansion_separator() |
        {
            "aab": attrs.option(attrs.dep(), default = None),
            "cacheable": attrs.option(attrs.bool(), default = None),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "enable_sandbox": attrs.option(attrs.bool(), default = None),
            "is_cacheable": attrs.bool(default = False),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "need_android_tools": attrs.bool(default = False),
            "remote": attrs.option(attrs.bool(), default = None),
        }
    ),
)

gen_aidl = prelude_rule(
    name = "gen_aidl",
    docs = """
        A `gen_aidl()` rule is used to generate `.java` files
        from `.aidl` files.
    """,
    examples = """
        ```

        android_library(
          name = 'lib',
          srcs = glob(['**/*.java']) + [':aidl'],
          manifest = '//res/org/opencv:manifest',
          deps = [
            '//res/org/opencv:res',
          ],
          visibility = [ 'PUBLIC' ],
        )

        gen_aidl(
            name = 'aidl',
            aidl = 'engine/OpenCVEngineInterface.aidl',
            import_path = 'java/',
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "aidl": attrs.source(doc = """
                The path to an `.aidl` file to convert to a
                 `.java` file.
            """),
            "import_path": attrs.string(default = "", doc = """
                The search path for import statements for the aidl command.
                 (This is the `-I` argument when invoking aidl
                 from the command line. For many apps it will be the base dir where all
                 aidl files are, with project root as its parent,
                 e.g. `app/src/main/aidl`.). This is the same as the path to the
                 `aidl` file relative to what would be returned from `root`.
            """),
            "import_paths": attrs.list(attrs.string(), default = [], doc = """
                A list of additional import statements for the aidl command.
                 (This appends an `-I` argument for each of the provided paths when
                 invoking aidl from the command line.
            """),
            "aidl_srcs": attrs.set(attrs.source(), sorted = True, default = [], doc = """
                Path to `.aidl` files the target `aidl` file imports.
            """),
            "deps": attrs.list(attrs.dep(), default = [], doc = """
                A list of rules that must be built before this rule.
            """),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
        }
    ),
)

keystore = prelude_rule(
    name = "keystore",
    docs = """
        A `keystore()` contains the data for a key pair
        created by the `keytool` executable that comes
        with the JDK. This is a required input for an `android\\_binary()`rule.
    """,
    examples = None,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "store": attrs.source(doc = """
                The path to the file that contains the key.
                 This is the path that was passed as the `-keystore` argument
                 when you ran `keytool`.
            """),
            "properties": attrs.source(doc = """
                The path to the `.properties` file that contains the following values:

                ```

                # The value that you passed as the argument to -alias
                # when you ran keytool.
                key.alias=my_alias

                # The value that you entered in response to
                # the "Enter keystore password:" prompt.
                key.store.password=store_password

                # The value that you entered in response to
                # the "Enter key password for <my_alias>" prompt.
                key.alias.password=alias_password
                ```
            """),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "deps": attrs.list(attrs.dep(), default = []),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
        }
    ),
)

ndk_library = prelude_rule(
    name = "ndk_library",
    docs = """
        An `ndk_library()` is used to define a set of C/C++ files,
        an `Android.mk` and an `Application.mk` file that
        are used by the NDK's `ndk-build` tool to generate one or more shared
        objects.
    """,
    examples = None,
    further = """
        An `android_binary()` that includes this library will
        aggregate all of the native shared objects into a directory in the
        root of the APK named `lib/` or `assets/lib/`.

        Unlike the default invocation of `ndk-build`,
         `buck` will put all intermediate files and build output
        into a subdirectory under `buck-out/gen`.
    """,
    attrs = (
        # @unsorted-dict-items
        {
            "srcs": attrs.list(attrs.source(), default = [], doc = """
                The set of files to compile for this rule.
                 If not provided, `buck` assumes
                 that all files with the following extensions are part of the build:
                 `c, cpp, cc, cxx, h, hpp, mk`.
            """),
            "deps": attrs.list(attrs.dep(), default = [], doc = """
                List of build targets to build before this rule.
            """),
            "flags": attrs.list(attrs.arg(), default = [], doc = """
                Array of strings passed verbatim to `ndk-build`. Normally
                 this is not needed, but in some cases you may want to put something
                 here. For example, this can be used to build the libraries in debug
                 mode (`NDK_DEBUG=1`) or set the number of jobs spawned by
                 `ndk-build` (by default, the same as the number of
                 cores).
            """),
            "is_asset": attrs.bool(default = False, doc = """
                Normally native shared objects end up in a directory in the root of the APK
                 named `lib/`. If this parameter is set to `True`, then
                 these objects are placed in `assets/lib/`. Placing shared objects in
                 a non-standard location prevents Android from extracting them to the device's
                 internal storage.
            """),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
        }
    ),
)

prebuilt_jar = prelude_rule(
    name = "prebuilt_jar",
    docs = """
        A `prebuilt_jar()` rule is used to identify a JAR file that
        is checked into our repository as a precompiled binary rather than one
        that is built from source by Buck. Frequently, these are used to
        reference third-party JAR files (such as junit.jar) and
        are used as dependencies of `java_library()` rules.
    """,
    examples = """
        ```

        prebuilt_jar(
          name = 'junit',
          binary_jar = 'junit-4.8.2.jar',
          source_jar = 'junit-4.8.2-sources.jar',
          javadoc_url = 'http://kentbeck.github.com/junit/javadoc/4.8/',
        )

        java_library(
          name = 'tests',
          srcs = glob(['tests/**/*Test.java']),
          deps = [
            ':junit',
          ],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "binary_jar": attrs.source(doc = """
                Path to the pre-built JAR file.
            """),
            "source_jar": attrs.option(attrs.source(), default = None, doc = """
                Path to a JAR file that contains the `.java` files to create
                 the `.class` in the `binary_jar`. This is frequently
                 provided for debugging purposes.
            """),
            "javadoc_url": attrs.option(attrs.string(), default = None, doc = """
                URL to the Javadoc for the `.class` files in the
                 `binary_jar`.
            """),
            "deps": attrs.list(attrs.dep(), default = [], doc = """
                Rules that must be built before this rule. Because the
                 `binary_jar` is already built, there should be nothing to
                 build, so this should be empty.
            """),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "generate_abi": attrs.bool(default = False),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "maven_coords": attrs.option(attrs.string(), default = None),
            "never_mark_as_unused_dependency": attrs.bool(default = False),
            "required_for_source_only_abi": attrs.bool(default = False),
        }
    ),
)

prebuilt_native_library = prelude_rule(
    name = "prebuilt_native_library",
    docs = """
        A `prebuilt_native_library()` rule is used to bundle native libraries
        (i.e., `.so` files) for Android.
    """,
    examples = """
        Most of the time, a `prebuilt_native_library` is private to the `android\\_library()`that uses it:


        ```

        prebuilt_native_library(
          name = 'native_libs',
          native_libs = 'libs',
        )

        android_library(
          name = 'my_lib',
          srcs = glob(['*.java']),
          deps = [
            ':native_libs',
          ],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "native_libs": attrs.source(doc = """
                Path to a directory containing native libraries.
                 This directory has subdirectories for different architectures,
                 such as `armeabi` and `armeabi-v7a`.
            """),
            "is_asset": attrs.bool(default = False, doc = """
                Normally native shared objects end up in a directory in the root of the APK
                 named `lib/`. If this parameter is set to `True`, then
                 these objects are placed in `assets/lib/`. Placing shared objects in
                 a non-standard location prevents Android from extracting them to the device's
                 internal storage.
            """),
            "has_wrap_script": attrs.bool(default = False, doc = """
                When using an exopackage, if this
                 parameter is set to `True`, then the libraries for this rule are
                 included in the primary APK even if native libraries would otherwise not be
                 placed in it. This is intended for a native library directory that contains a
                 [wrap.sh](https://developer.android.com/ndk/guides/wrap-script)
                 script, which must be included in the primary APK to take effect. Only one
                 of `is_asset` and `has_wrap_script` can be set for a rule.
            """),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "deps": attrs.list(attrs.dep(), default = []),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
        }
    ),
)

robolectric_test = prelude_rule(
    name = "robolectric_test",
    docs = """
        A `robolectric_test()` rule is used to define a set of
         `.java` files that contain tests to run via JUnit
        with Robolectric test runner. It extends from `java_test()` rule.
    """,
    examples = None,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "robolectric_runtime_dependency": attrs.option(attrs.source(), default = None, doc = """
                Robolectric only runs in offline mode with buck. Specify the relative
                 directory containing all the jars Robolectric uses at runtime.
            """),
            "robolectric_manifest": attrs.source(doc = """
                An [Android Manifest](http://developer.android.com/guide/topics/manifest/manifest-intro.html) for the rule to declare any permissions or intents it may need or want to handle. May either be a file or a `android\\_manifest()`target.
            """),
            "extra_kotlinc_arguments": attrs.list(attrs.string(), default = [], doc = """
                List of additional arguments to pass into the Kotlin compiler.
            """),
            "abi_generation_mode": attrs.option(attrs.enum(AbiGenerationMode), default = None),
            "annotation_processing_tool": attrs.option(attrs.enum(AnnotationProcessingTool), default = None),
            "annotation_processor_deps": attrs.list(attrs.dep(), default = []),
            "annotation_processor_params": attrs.list(attrs.string(), default = []),
            "annotation_processors": attrs.list(attrs.string(), default = []),
            "contacts": attrs.list(attrs.string(), default = []),
            "cxx_library_whitelist": attrs.list(attrs.dep(), default = []),
            "default_cxx_platform": attrs.option(attrs.string(), default = None),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "deps": attrs.list(attrs.dep(), default = []),
            "deps_query": attrs.option(attrs.query(), default = None),
            "env": attrs.dict(key = attrs.string(), value = attrs.arg(), sorted = False, default = {}),
            "exported_deps": attrs.list(attrs.dep(), default = []),
            "exported_provided_deps": attrs.list(attrs.dep(), default = []),
            "extra_arguments": attrs.list(attrs.string(), default = []),
            "extra_non_source_only_abi_kotlinc_arguments": attrs.list(attrs.string(), default = []),
            "fork_mode": attrs.enum(ForkMode, default = "none"),
            "friend_paths": attrs.list(attrs.dep(), default = []),
            "java_version": attrs.option(attrs.string(), default = None),
            "java": attrs.option(attrs.dep(), default = None),
            "javac": attrs.option(attrs.source(), default = None),
            "kotlin_compiler_plugins": attrs.dict(key = attrs.source(), value = attrs.dict(key = attrs.string(), value = attrs.string(), sorted = False), sorted = False, default = {}),
            "labels": attrs.list(attrs.string(), default = []),
            "language": attrs.option(attrs.enum(JvmLanguage), default = None),
            "licenses": attrs.list(attrs.source(), default = []),
            "locales_for_binary_resources": attrs.list(attrs.string(), default = []),
            "manifest": attrs.option(attrs.source(), default = None),
            "manifest_entries": attrs.dict(key = attrs.string(), value = attrs.any(), default = {}),
            "manifest_file": attrs.option(attrs.source(), default = None),
            "maven_coords": attrs.option(attrs.string(), default = None),
            "never_mark_as_unused_dependency": attrs.option(attrs.bool(), default = None),
            "on_unused_dependencies": attrs.option(attrs.enum(UnusedDependenciesAction), default = None),
            "plugins": attrs.list(attrs.dep(), default = []),
            "preferred_density_for_binary_resources": attrs.option(attrs.string(), default = None),
            "proguard_config": attrs.option(attrs.source(), default = None),
            "provided_deps": attrs.list(attrs.dep(), default = []),
            "provided_deps_query": attrs.option(attrs.query(), default = None),
            "remove_classes": attrs.list(attrs.regex(), default = []),
            "required_for_source_only_abi": attrs.bool(default = False),
            "resource_union_package": attrs.option(attrs.string(), default = None),
            "resources": attrs.list(attrs.source(), default = []),
            "resources_root": attrs.option(attrs.source(), default = None),
            "robolectric_runtime_dependencies": attrs.list(attrs.dep(), default = []),
            "run_test_separately": attrs.bool(default = False),
            "runtime_deps": attrs.list(attrs.dep(), default = []),
            "source": attrs.option(attrs.string(), default = None),
            "source_abi_verification_mode": attrs.option(attrs.enum(SourceAbiVerificationMode), default = None),
            "source_only_abi_deps": attrs.list(attrs.dep(), default = []),
            "srcs": attrs.list(attrs.source(), default = []),
            "std_err_log_level": attrs.option(attrs.one_of(attrs.enum(LogLevel), attrs.int()), default = None),
            "std_out_log_level": attrs.option(attrs.one_of(attrs.enum(LogLevel), attrs.int()), default = None),
            "target": attrs.option(attrs.string(), default = None),
            "test_case_timeout_ms": attrs.option(attrs.int(), default = None),
            "test_rule_timeout_ms": attrs.option(attrs.int(), default = None),
            "test_type": attrs.option(attrs.enum(TestType), default = None),
            "unbundled_resources_root": attrs.option(attrs.source(allow_directory = True), default = None),
            "use_cxx_libraries": attrs.option(attrs.bool(), default = None),
            "use_dependency_order_classpath": attrs.option(attrs.bool(), default = None),
            "use_jvm_abi_gen": attrs.option(attrs.bool(), default = None),
            "vm_args": attrs.list(attrs.arg(), default = []),
        }
    ),
)

supermodule_target_graph = prelude_rule(
    name = "supermodule_target_graph",
    docs = "",
    examples = None,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "deps": attrs.set(attrs.dep(), sorted = True, default = []),
            "label_pattern": attrs.option(attrs.regex(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "on_duplicate_entry": attrs.enum(OnDuplicateEntry, default = "overwrite"),
            "out": attrs.string(default = ""),
        }
    ),
)

android_rules = struct(
    android_aar = android_aar,
    android_app_modularity = android_app_modularity,
    android_binary = android_binary,
    android_build_config = android_build_config,
    android_bundle = android_bundle,
    android_instrumentation_apk = android_instrumentation_apk,
    android_instrumentation_test = android_instrumentation_test,
    android_library = android_library,
    android_manifest = android_manifest,
    android_platform = android_platform,
    android_prebuilt_aar = android_prebuilt_aar,
    android_resource = android_resource,
    apk_genrule = apk_genrule,
    gen_aidl = gen_aidl,
    keystore = keystore,
    ndk_library = ndk_library,
    prebuilt_jar = prebuilt_jar,
    prebuilt_native_library = prebuilt_native_library,
    robolectric_test = robolectric_test,
    supermodule_target_graph = supermodule_target_graph,
)
