# Copyright (c) Meta Platforms, Inc. and affiliates.
#
# This source code is licensed under both the MIT license found in the
# LICENSE-MIT file in the root directory of this source tree and the Apache
# License, Version 2.0 found in the LICENSE-APACHE file in the root directory
# of this source tree.

# TODO(cjhopman): This was generated by scripts/hacks/rules_shim_with_docs.py,
# but should be manually edited going forward. There may be some errors in
# the generated docs, and so those should be verified to be accurate and
# well-formatted (and then delete this TODO)

def _headers_arg():
    return {
        "headers": attrs.named_set(attrs.source(), sorted = True, default = [], doc = """
    The set of header files that are made available for inclusion to the source files in this
     target. These should be specified as either a list of header files or a dictionary of header names
     to header files. The header names can contain forward slashes (`/`). If a list of
     header files is specified, the headers can be imported
     with `#import "$HEADER_PATH_PREFIX/$HEADER_NAME"` or `#import
     "$HEADER_NAME"`, where `$HEADER_PATH_PREFIX` is the value of
     the target's `header_path_prefix` attribute, and `$HEADER_NAME` is
     the filename of the header file. If a dictionary is specified, each header can be imported
     with `#import "$HEADER_NAME"`, where `$HEADER_NAME` is the key
     corresponding to this file. In this case, the `header_path_prefix` attribute is
     ignored. In either case, quotes in the import statements can be replaced with angle brackets.
"""),
    }

def _exported_headers_arg():
    return {
        "exported_headers": attrs.named_set(attrs.source(), sorted = True, default = [], doc = """
    The set of header files that are made available for inclusion to the source files in this
     target and all targets that transitively depend on this one. These should be specified as
     either a list of header files or a dictionary of header names
     to header files. The header names can contain forward slashes (`/`). If a list of
     header files is specified, the headers can be imported
     with `#import "$HEADER_PATH_PREFIX/$HEADER_NAME"` or, if a header file that belongs to
     the same rule is being imported, with `#import
     "$HEADER_NAME"`, where `$HEADER_PATH_PREFIX` is the value of
     the target's `header_path_prefix` attribute, and `$HEADER_NAME` is
     the filename of the header file. If a dictionary is specified, each header can be imported
     with `#import "$HEADER_NAME"`, where `$HEADER_NAME` is the key
     corresponding to this file. In this case, the `header_path_prefix` attribute is
     ignored. In either case, quotes in the import statements can be replaced with angle brackets.
"""),
    }

def _header_path_prefix_arg():
    return {
        "header_path_prefix": attrs.option(attrs.string(), default = None, doc = """
    A path prefix when including headers of this target. For example, headers from a library defined
     using

    ```

    apple_library(
        name = "Library",
        headers = glob(["**/*.h"]),
        header_path_prefix = "Lib",
    )

    ```
    can be imported using following mapping

    ```

    Library/SubDir/Header1.h -> Lib/Header1.h
    Library/Header2.h -> Lib/Header2.h

    ```
    Defaults to the short name of the target. Can contain forward slashes (`/`), but
     cannot start with one. See `headers` for more information.
"""),
    }

def _frameworks_arg():
    return {
        "frameworks": attrs.list(attrs.string(), default = [], doc = """
    A list of system frameworks that the code in this target uses. Each entry should be a path
     starting with `$SDKROOT` or `$PLATFORM_DIR` to denote that the rest of the
     path is relative to the root of the SDK used for the build or to the platform toolchain
     directory.
"""),
    }

def _target_sdk_version():
    return {
        "target_sdk_version": attrs.option(attrs.string(), default = None, doc = """
    The minimum OS version that the library target should support, overriding the minimum set in
     `.buckconfig`. When set, Buck will automatically add flags to both Objective-C and
     Swift compilation that will allow the use of the new APIs without guarding code inside availability
     checks.
"""),
    }

def _info_plist_arg():
    return {
        "info_plist": attrs.source(doc = """
    A path to an `Info.plist` file that will be placed in the bundle. The specified file
     will be processed by substituting variable names with their values
     (see `info_plist_substitutions` for more information).
"""),
    }

def _info_plist_substitutions_arg():
    return {
        "info_plist_substitutions": attrs.dict(key = attrs.string(), value = attrs.string(), sorted = False, default = {}, doc = """
    A dictionary that assigns variable names to their values. It is used for variable
     substitution when processing the file specified in `info_plist`. For example if this
     argument is set to `{\'VAR\': \'MyValue\'}`, then each occurrence of `$(VAR)` or `${VAR}` in the file will be replaced by `MyValue`.
"""),
    }

def _extra_xcode_sources():
    return {
        "extra_xcode_sources": attrs.list(attrs.source(), default = [], doc = """
    When the project is generated, this is the list of files that will added to the build phase
     "Compile Sources" of the given target.
"""),
    }

def _extra_xcode_files():
    return {
        "extra_xcode_files": attrs.list(attrs.source(), default = [], doc = """
    When the project is generated, this is the list of files that will added to the project.
     Those files won't be added to the build phase "Compile Sources".
"""),
    }

apple_common = struct(
    headers_arg = _headers_arg,
    exported_headers_arg = _exported_headers_arg,
    header_path_prefix_arg = _header_path_prefix_arg,
    frameworks_arg = _frameworks_arg,
    target_sdk_version = _target_sdk_version,
    info_plist_arg = _info_plist_arg,
    info_plist_substitutions_arg = _info_plist_substitutions_arg,
    extra_xcode_sources = _extra_xcode_sources,
    extra_xcode_files = _extra_xcode_files,
)
