# Copyright (c) Meta Platforms, Inc. and affiliates.
#
# This source code is licensed under both the MIT license found in the
# LICENSE-MIT file in the root directory of this source tree and the Apache
# License, Version 2.0 found in the LICENSE-APACHE file in the root directory
# of this source tree.

# TODO(cjhopman): This was generated by scripts/hacks/rules_shim_with_docs.py,
# but should be manually edited going forward. There may be some errors in
# the generated docs, and so those should be verified to be accurate and
# well-formatted (and then delete this TODO)

load(":apple_common.bzl", "apple_common")
load(":common.bzl", "CxxRuntimeType", "CxxSourceType", "HeadersAsRawHeadersMode", "LinkableDepType", "Linkage", "Traversal", "buck", "prelude_rule")
load(":cxx_common.bzl", "cxx_common")
load(":genrule_common.bzl", "genrule_common")
load(":native_common.bzl", "native_common")

ArchiveContents = ["normal", "thin"]

ArchiverProviderType = ["bsd", "gnu", "llvm", "windows", "windows_clang"]

CxxTestType = ["gtest", "boost"]

CxxToolProviderType = ["clang", "clang_cl", "clang_windows", "gcc", "windows", "windows_ml64"]

LinkerProviderType = ["darwin", "gnu", "windows", "unknown"]

PicType = ["pic", "pdc"]

SharedLibraryInterfaceParamsType = ["disabled", "enabled", "defined_only"]

cxx_binary = prelude_rule(
    name = "cxx_binary",
    docs = """
        A cxx\\_binary() rule builds a native executable from the supplied set of C/C++ source files and
        dependencies. If C/C++ library dependencies are listed, the generated native executable will request
        and link against their static archives (which are \\*not\\* built using [PIC](http://en.wikipedia.org/wiki/Position-independent_code)).
    """,
    examples = """
        ```

        # A rule that builds a C/C++ native executable from a single .cpp file
        # its corresponding header, and a C/C++ library dependency.
        cxx_binary(
          name = 'echo',
          srcs = [
            'echo.cpp',
          ],
          headers = [
            'echo.h',
          ],
          deps = [
            ':util',
          ],
        )

        cxx_library(
          name = 'util',
          srcs = [
            'util.cpp',
          ],
          headers = [
            'util.h',
          ],
        )

        # To build without stripping:
        buck build :echo

        # To build with stripping debug symbols only:
        buck build :echo#strip-debug

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        cxx_common.srcs_arg() |
        cxx_common.platform_srcs_arg() |
        cxx_common.headers_arg() |
        cxx_common.platform_headers_arg() |
        cxx_common.header_namespace_arg() |
        cxx_common.preprocessor_flags_arg() |
        cxx_common.platform_preprocessor_flags_arg() |
        cxx_common.compiler_flags_arg() |
        cxx_common.platform_compiler_flags_arg() |
        cxx_common.linker_extra_outputs_arg() |
        cxx_common.linker_flags_arg() |
        cxx_common.platform_linker_flags_arg() |
        cxx_common.precompiled_header_arg() |
        native_common.link_style() |
        buck.deps_query_arg() |
        cxx_common.raw_headers_arg() |
        cxx_common.include_directories_arg() |
        {
            "contacts": attrs.list(attrs.string(), default = []),
            "cxx_runtime_type": attrs.option(attrs.enum(CxxRuntimeType), default = None),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "default_platform": attrs.option(attrs.string(), default = None),
            "defaults": attrs.dict(key = attrs.string(), value = attrs.string(), sorted = False, default = {}),
            "deps": attrs.list(attrs.dep(), default = []),
            "devirt_enabled": attrs.bool(default = False),
            "executable_name": attrs.option(attrs.string(), default = None),
            "fat_lto": attrs.bool(default = False),
            "focused_list_target": attrs.option(attrs.dep(), default = None),
            "frameworks": attrs.list(attrs.string(), default = []),
            "headers_as_raw_headers_mode": attrs.option(attrs.enum(HeadersAsRawHeadersMode), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "lang_compiler_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.arg()), sorted = False, default = {}),
            "lang_platform_compiler_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg()))), sorted = False, default = {}),
            "lang_platform_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg()))), sorted = False, default = {}),
            "lang_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.arg()), sorted = False, default = {}),
            "libraries": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "link_deps_query_whole": attrs.bool(default = False),
            "link_group": attrs.option(attrs.string(), default = None),
            "link_group_map": attrs.option(attrs.list(attrs.tuple(attrs.string(), attrs.list(attrs.tuple(attrs.dep(), attrs.enum(Traversal), attrs.option(attrs.string()))))), default = None),
            "platform_deps": attrs.list(attrs.tuple(attrs.regex(), attrs.set(attrs.dep(), sorted = True)), default = []),
            "post_linker_flags": attrs.list(attrs.arg(anon_target_compatible = True), default = []),
            "post_platform_linker_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg(anon_target_compatible = True))), default = []),
            "prefer_stripped_objects": attrs.bool(default = False),
            "prefix_header": attrs.option(attrs.source(), default = None),
            "resources": attrs.named_set(attrs.source(), sorted = True, default = []),
            "thin_lto": attrs.bool(default = False),
            "version_universe": attrs.option(attrs.string(), default = None),
            "weak_framework_names": attrs.list(attrs.string(), default = []),
        } |
        buck.allow_cache_upload_arg()
    ),
)

cxx_genrule = prelude_rule(
    name = "cxx_genrule",
    docs = """
        A `cxx_genrule()` enables you to run shell commands as part
        of the Buck build process. A `cxx_genrule()` exposes\342\200\224through
        a set of string parameter macros and variables\342\200\224information about the
        tools and configuration options used by the
        Buck environment, specifically those related to the C/C++ toolchain.


        The information exposed through these tools and configuration options is a reflection of:
        Buck's built-in settings,
        the settings in `.buckconfig`
        and `.buckconfig.local`,
        and the result of various command-line overrides specified through
        the `common\\_parameters`command-line option.


        This information is available only
        to the shell commands specified in the `cxx_genrule`.
        The information is not available to other arguments of the rule.


        A `cxx_genrule()` can be an input to
        another `cxx_genrule()`.


        Note that if you specify the `cxx_genrule` as a command-line
        target to `buck build`, you must include a platform flavor.
        For example:



        ```


        buck build :cxx_gr_name#iphonesimulator-x86_64

        ```



        You could also just specify the default platform flavor explicitly:



        ```


        buck build :cxx_gr_name#default

        ```
    """,
    examples = None,
    further = None,
    attrs = (
        # @unsorted-dict-items
        genrule_common.srcs_arg() |
        {
            "cmd": attrs.option(attrs.arg(), default = None, doc = """
                The shell command to run to generate the output file. It is the fallback of `bash`
                 and `cmd_exe`. The shell command can access information
                 about the buck build environment through a set
                 of *macros*, *parameterized macros*, and *variables*.

                 #### Macros

                 The following macros are available to the shell command and are
                 accessed using the following syntax.


                ```
                $(<macro>)
                ```


                 Example:


                ```
                $(cc)
                ```


                `$(cc)`
                Path to the C compiler.


                `$(cxx)`
                Path to the C++ compiler.


                `$(cflags)`
                Flags passed to the C compiler.


                `$(cppflags)`
                Flags passed to the C preprocessor.


                `$(cxxflags)`
                Flags passed to the C++ compiler.


                `$(cxxppflags)`
                Flags to pass to the C++ preprocessor.


                `$(ld)`
                Path to the linker.


                `$(ldflags-pic)`
                Flags passed to the linker for binaries that use
                 position-independent code (PIC).


                `$(ldflags-pic-filter <pattern>)`
                Flags passed to the linker for binaries that use position-independent code (PIC).
                 Use the *pattern* parameter to specify a regular expression that matches the build targets that use these flags.



                `$(ldflags-shared)`
                Flags passed to the linker for shared libraries, such as dynamic-link libraries (DLLs).


                `$(ldflags-shared-filter <pattern>)`
                Flags passed to the linker for shared libraries, such as dynamic-link libraries (DLLs).
                 Use the *pattern* parameter to specify a regular expression that matches the build targets that use these flags.



                `$(ldflags-static)`
                Flags passed to the linker for statically-linked libraries.


                `$(ldflags-static-filter <pattern>)`
                Flags passed to the linker for statically-linked libraries.
                 Use the *pattern* parameter to specify a regular expression that matches the build targets that use these flags.



                `$(platform-name)`
                The platform flavor with which this `cxx_genrule` was specified.


                #### Parameterized Macros

                 It is also possible to expand references to other rules within the
                 shell command, using the following subset of the
                 builtin `string parameter macros`
                .
                 Note that all build rules expanded in the command are automatically
                 considered to be dependencies of the `genrule()`.


                 Note that the paths returned by these macros are *absolute* paths. You should convert these paths to be relative paths before
                 embedding them in, for example, a shell script or batch file. Using
                 relative paths ensures that your builds are *hermetic*, that
                 is, they are reproducible across different machine environments.


                 Additionally, if you embed these paths in a shell script, you should
                 execute that script using the `sh\\_binary()`rule and include
                 the targets for these paths in the `resources` argument of
                 that `sh_binary` rule. These are the same targets that you
                 pass to the string parameter macros.


                `$(exe //path/to:target)`
                Expands to the commands necessary to run the executable
                 generated by the specified build rule. For a C++ executable, this
                 will typically just be the name of the output executable itself,
                 such as `main`. If the specified build rule does not generate an
                 executable output, an exception will be thrown and the build will
                 fail.


                `$(location //path/to:target)`
                Expands to the path of the output of the build rule. This
                 means that you can refer to these without needing to be aware of
                 how Buck is storing data on the disk mid-build.

                #### Variables

                 Finally, Buck adds the following variables to the environment in
                 which the shell command runs. They are accessed using the following syntax.
                 Note the use of braces rather than parentheses.


                ```
                ${<variable>}
                ```


                 Example:


                ```
                ${SRCS}
                ```


                `${SRCS}`
                A string expansion of the `srcs` argument delimited by
                 the `environment_expansion_separator` argument where each element
                 of `srcs` will be translated into an absolute path.


                `${SRCDIR}`
                The absolute path to the to which sources are copied
                 prior to running the command.


                `${OUT}`
                The output file for the `genrule()`. The file
                 specified by this variable must always be written by this
                 command. If not, the execution of this rule will be considered a
                 failure, halting the build process.


                `${TMP}`
                A temporary directory which can be used for intermediate results and will not be
                 bundled into the output.
            """),
        } |
        genrule_common.bash_arg() |
        genrule_common.cmd_exe_arg() |
        genrule_common.type_arg() |
        genrule_common.out_arg() |
        genrule_common.environment_expansion_separator() |
        {
            "enable_sandbox": attrs.option(attrs.bool(), default = None, doc = """
                Whether this target should be executed in a sandbox or not.
            """),
            "cacheable": attrs.option(attrs.bool(), default = None),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "default_outs": attrs.option(attrs.set(attrs.string(), sorted = False), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "need_android_tools": attrs.bool(default = False),
            "outs": attrs.option(attrs.dict(key = attrs.string(), value = attrs.set(attrs.string(), sorted = False), sorted = False), default = None),
            "remote": attrs.option(attrs.bool(), default = None),
        }
    ),
)

cxx_library = prelude_rule(
    name = "cxx_library",
    docs = """
        A `cxx_library()` rule specifies a set of C/C++ source files
        and also provides flags that specify how those files should be built.

        #### Building requires a specified top-level target

        Whether a Buck command builds the `cxx_library` is
        determined by the inclusion of a top-level target, such as
        a `cxx\\_binary()`or `android\\_binary()`, that
        transitively depends on the `cxx_library`. The set of
        targets specified to the Buck command (`buck build`, `buck run`, etc) must
        include one of these top-level targets in order for Buck to build
        the `cxx_library`. Note that you could specify the top-level target
        implicitly using a `build target pattern`or you could also specify
        the top-level target using an buckconfig#`alias`defined in `.buckconfig`.


        *How* Buck builds the library also depends on the specified top-level target.
        For example, a C/C++ binary (`cxx_binary`) would require a static non-PIC build of the library,
        whereas an Android APK (`android_binary`) would require a shared PIC-enabled build.
        (PIC stands for position-independent code.)

        #### Dependencies of the cxx\\_library also require a top-level target

        Similarly, in order for Buck to build a target that
        the `cxx_library` depends on, such as a `cxx\\_genrule()`,
        you must specify in the Buck command a top-level target that depends on
        the `cxx_library`. For example, you could specify
        to `build`a `cxx_binary` that
        depends on the `cxx_library`. If you specify as
        your build target the `cxx_library` itself, the build targets
        that the `cxx_library` depends on *might not be built*.
    """,
    examples = """
        ```

        # A rule that includes a single .cpp file and its corresponding header and
        # also supplies an additional flag for compilation.
        cxx_library(
          name = 'fileutil',
          srcs = [
            'fileutil.cpp',
          ],
          exported_headers = [
            'fileutil.h',
          ],
          compiler_flags = [
            '-fno-omit-frame-pointer',
          ],
        )

        # A rule that defines explicit names for its headers
        cxx_library(
          name = 'mathutils',
          header_namespace = 'math',
          srcs = [
            'trig/src/cos.cpp',
            'trig/src/tan.cpp',
          ],
          exported_headers = {
            # These are included as <math/trig/cos.h> and <math/trig/tan.h>
            'trig/cos.h': 'trig/include/cos.h',
            'trig/tan.h': 'trig/include/tan.h',
          },
          compiler_flags = [
            '-fno-omit-frame-pointer',
          ],
        )

        # A rule that uses different headers and sources per platform
        cxx_library(
          name = 'vector',
          # Because of platform_headers, this file can include "config.h"
          # and get the architecture specific header
          srcs = ['vector.cpp'],
          platform_srcs = [
            ('.*armv7$', 'armv7.S'),
            ('.*x86_64$', 'x86_64.S'),
          ],
          exported_headers = [
            'vector.h',
          ],
          platform_headers = [
            (
              '.*armv7$',
              {
                'config.h': 'config-armv7.h',
              }
            ),
            (
              '.*x86_64$',
              {
                'config.h': 'config-x86_64.h',
              }
            ),
          ],
        )


        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        cxx_common.srcs_arg() |
        cxx_common.platform_srcs_arg() |
        cxx_common.headers_arg() |
        cxx_common.platform_headers_arg() |
        cxx_common.exported_headers_arg() |
        cxx_common.exported_header_style_arg() |
        cxx_common.exported_platform_headers_arg() |
        cxx_common.header_namespace_arg() |
        cxx_common.preprocessor_flags_arg() |
        cxx_common.lang_preprocessor_flags_arg() |
        cxx_common.platform_preprocessor_flags_arg() |
        cxx_common.lang_platform_preprocessor_flags_arg() |
        cxx_common.exported_preprocessor_flags_arg(exported_preprocessor_flags_type = attrs.list(attrs.arg(), default = [])) |
        cxx_common.exported_lang_preprocessor_flags_arg() |
        cxx_common.exported_platform_preprocessor_flags_arg() |
        cxx_common.exported_lang_platform_preprocessor_flags_arg() |
        cxx_common.compiler_flags_arg() |
        cxx_common.lang_compiler_flags_arg() |
        cxx_common.platform_compiler_flags_arg() |
        cxx_common.lang_platform_compiler_flags_arg() |
        cxx_common.linker_extra_outputs_arg() |
        cxx_common.linker_flags_arg() |
        cxx_common.platform_linker_flags_arg() |
        cxx_common.exported_linker_flags_arg() |
        cxx_common.exported_post_linker_flags_arg() |
        cxx_common.exported_platform_linker_flags_arg() |
        cxx_common.exported_post_platform_linker_flags_arg() |
        native_common.link_style() |
        native_common.link_whole(link_whole_type = attrs.option(attrs.bool(), default = None)) |
        cxx_common.raw_headers_arg() |
        cxx_common.include_directories_arg() |
        cxx_common.public_include_directories_arg() |
        cxx_common.public_system_include_directories_arg() |
        {
            "soname": attrs.option(attrs.string(), default = None, doc = """
                Sets the soname ("shared object name") of any shared library produced from this rule.
                 The default value is based on the full rule name.
                 The macro `$(ext)` will be replaced with a platform-appropriate extension.
                 An argument can be provided, which is a library version.
                 For example `soname = 'libfoo.$(ext 2.3)'` will be `libfoo.2.3.dylib` on Mac and `libfoo.so.2.3` on Linux.
            """),
            "used_by_wrap_script": attrs.bool(default = False, doc = """
                When using an exopackage
                 Android, if this parameter is set to `True`, then the library is
                 included in the primary APK even if native libraries would otherwise not be
                 placed in it. This is intended for native libraries that are used by a
                 [wrap.sh](https://developer.android.com/ndk/guides/wrap-script)
                 script, which must be placed in the primary APK. Only one of
                 `can_be_asset` and `used_by_wrap_script` can be set
                 for a rule.
            """),
        } |
        cxx_common.supported_platforms_regex_arg() |
        cxx_common.force_static(force_static_type = attrs.option(attrs.bool(), default = None)) |
        native_common.preferred_linkage(preferred_linkage_type = attrs.option(attrs.enum(Linkage), default = None)) |
        cxx_common.reexport_all_header_dependencies_arg() |
        cxx_common.exported_deps_arg() |
        cxx_common.exported_platform_deps_arg() |
        cxx_common.precompiled_header_arg() |
        apple_common.extra_xcode_sources() |
        apple_common.extra_xcode_files() |
        {
            "bridging_header": attrs.option(attrs.source(), default = None),
            "can_be_asset": attrs.option(attrs.bool(), default = None),
            "contacts": attrs.list(attrs.string(), default = []),
            "cxx_runtime_type": attrs.option(attrs.enum(CxxRuntimeType), default = None),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "default_platform": attrs.option(attrs.string(), default = None),
            "defaults": attrs.dict(key = attrs.string(), value = attrs.string(), sorted = False, default = {}),
            "deps": attrs.list(attrs.dep(), default = []),
            "devirt_enabled": attrs.bool(default = False),
            "diagnostics": attrs.dict(key = attrs.string(), value = attrs.source(), sorted = False, default = {}),
            "executable_name": attrs.option(attrs.string(), default = None),
            "fat_lto": attrs.bool(default = False),
            "focused_list_target": attrs.option(attrs.dep(), default = None),
            "frameworks": attrs.list(attrs.string(), default = []),
            "headers_as_raw_headers_mode": attrs.option(attrs.enum(HeadersAsRawHeadersMode), default = None),
            "include_in_android_merge_map_output": attrs.bool(default = False),
            "labels": attrs.list(attrs.string(), default = []),
            "libraries": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "link_group": attrs.option(attrs.string(), default = None),
            "link_group_map": attrs.option(attrs.list(attrs.tuple(attrs.string(), attrs.list(attrs.tuple(attrs.dep(), attrs.enum(Traversal), attrs.option(attrs.string()))))), default = None),
            "module_name": attrs.option(attrs.string(), default = None),
            "platform_deps": attrs.list(attrs.tuple(attrs.regex(), attrs.set(attrs.dep(), sorted = True)), default = []),
            "post_linker_flags": attrs.list(attrs.arg(anon_target_compatible = True), default = []),
            "post_platform_linker_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg(anon_target_compatible = True))), default = []),
            "prefix_header": attrs.option(attrs.source(), default = None),
            "resources": attrs.named_set(attrs.source(), sorted = True, default = []),
            "sdk_modules": attrs.list(attrs.string(), default = []),
            "static_library_basename": attrs.option(attrs.string(), default = None),
            "supports_merged_linking": attrs.option(attrs.bool(), default = None),
            "thin_lto": attrs.bool(default = False),
            "use_archive": attrs.option(attrs.bool(), default = None),
            "uses_cxx_explicit_modules": attrs.bool(default = False),
            "uses_explicit_modules": attrs.bool(default = False),
            "version_universe": attrs.option(attrs.string(), default = None),
            "weak_framework_names": attrs.list(attrs.string(), default = []),
            "xcode_private_headers_symlinks": attrs.option(attrs.bool(), default = None),
            "xcode_public_headers_symlinks": attrs.option(attrs.bool(), default = None),
        }
    ),
)

cxx_precompiled_header = prelude_rule(
    name = "cxx_precompiled_header",
    docs = """
        A `cxx_precompiled_header` rule specifies a single header file that can be
         precompiled and made available for use in other build rules such as
         a `cxx\\_library()`or a `cxx\\_binary()`.


         This header file is precompiled by the preprocessor on behalf of the
         C, C++, Objective-C, or Objective-C++ rule using it, via its `precompiled_header` parameter.
         Afterwards the precompiled header is applied during the rule's own compilation
         (often with an appreciable reduction in build time, the main benefit of PCH).


         This PCH is built once per combination of build flags which might affect the PCH's compatibility.
         For example, a distinct pre-compilation of the header occurs per combination of flags related to
         optimization, debug, architecture, and so on, used by rules which employ PCH.
         The flags used during the build of the dependent rule (that is, the "PCH-using rule")
         are in effect while building the PCH itself. Similarly, to the same end, the include paths used
         when building the PCH are applied to the dependent rule. For example, `deps` in the
         PCH rule are propagated back to the dependent rule, and the PCH's header search paths
         (e.g. `-I` or `-isystem` options) are prefixed onto the list of
         include paths for the dependent rule.
    """,
    examples = """
        The best way to see how the `cxx_precompiled_header()` rule works is with an
        example. Let there be a header called `common.h` which has the following:


        ```

        #pragma once

        /* Include common C++ files. */
        #include <string>
        #include <map>
        #include <set>
        #include <type_traits>
        #include <vector>

        /* Some frequently-used headers from the Folly project. */
        #include <folly/Conv.h>
        #include <folly/Executor.h>
        #include <folly/io/async/EventBase.h>

        ```


        ```

        cxx_precompiled_header(
          name = 'common_pch',
          src = 'common.h',
          deps = [
            # Needed for standard C++ headers:
            '//external/libcxx:headers',
            # Needed for the Folly includes:
            '//folly:folly',
            '//folly/io/async:async',
          ],
        )

        cxx_binary(
          name = 'main',
          srcs = ['main.cpp'],
          precompiled_header = ':common_pch',
          deps = [ ... ],
          compiler_flags = ['-g', '-O2', '-fPIC'],
        )

        ```


        The `cxx_precompiled_header` rule declares a precompiled header "template"
        containing the header file path, and dependencies.
        In this example we indicate that `common.h` is to be precompiled when used by another build rule.


        Note that, by itself, this `cxx_precompiled_header` rule will not result
        in anything being built. The *usage* of this rule from another rule --
        an "instantiation" of this precompiled header template -- is what will trigger the
        PCH build.


        In the example above, the build for the binary named `"main"` will depend on
        the header being precompiled in a separate step, prior to compiling `main.cpp`,
        and the resulting PCH will be used in `main`'s compilation.


        The dependencies specified in this precompiled header rule's `deps` are transitive; they
        will propagate to rules using this PCH, so that during link time, any libraries which are
        required by the code made available in the header will be included in the final binary build.


        The precompiled header dynamically created from the "template" will be built with flags
        which would be used in the dependent rule. In this case, `main`'s use of specific
        compiler flags `-g -O2 -fPIC` will result in the production of a precompiled header
        with the same flags. This is so the precompiled code fully jives with rules using the PCH,
        i.e. they will have the same debug, optimization, CPU, etc. options. (The compiler is usually
        smart enough to reject a bad PCH, fortunately. But we want to ensure we take the appropriate
        steps to ensure we *always have* a PCH which works with any build that uses it.)


        Another effect of a rule using a precompiled header is that the rule's list of
        build flags will change; not just to employ PCH with e.g. `-include-pch` (if using Clang), but also, to alter the sequence of header search paths.
        The rule using the precompiled header will "inherit" the lists of paths used
        during the PCH build, applying them *first* in its own search paths.
        This is to ensure that an `#include` directive will resolve in exactly
        the same way in this build as it would have in the PCH, to ensure full compatibility
        between the PCH and other rule's builds. For example, if the PCH were to use one version
        of `stdcxx` and another rule use a different version, the version differences
        won't clash, thereby avoiding different versions of the `<cstring>` header
        used between the precompiled header and the dependent rule, and preventing confused
        structure definitions, ABI incompatibility, and so on (catastrophe, in other words).
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "src": attrs.source(doc = """
                The path to the header file that should be precompiled.
                 Only one header file can be specified. But of course this header could include
                 any number of other headers. The included headers could belong to -- that is,
                 be `exported_headers` from -- another rule, in which case, the rule would
                 have to be added to `deps` as usual.
            """),
            "deps": attrs.list(attrs.dep(), default = [], doc = """
                Dependency rules which export headers used by the header specified in `src`.
            """),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "version_universe": attrs.option(attrs.string(), default = None),
        }
    ),
)

cxx_test = prelude_rule(
    name = "cxx_test",
    docs = """
        A cxx\\_test() rule builds a C/C++ binary against a C/C++ testing framework and runs
        it as part of `test`.
    """,
    examples = """
        ```

        # A rule that builds and runs C/C++ test using gtest.
        cxx_test(
          name = 'echo_test',
          srcs = [
            'echo_test.cpp',
          ],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        cxx_common.srcs_arg() |
        cxx_common.headers_arg() |
        cxx_common.preprocessor_flags_arg() |
        cxx_common.compiler_flags_arg() |
        cxx_common.linker_flags_arg() |
        cxx_common.precompiled_header_arg() |
        buck.deps_query_arg() |
        {
            "resources": attrs.named_set(attrs.source(), sorted = True, default = [], doc = """
                This attribute is currently not implemented, and just causes buck to rebuild
                 the test file if any of the resources change. This will change in the future
                 to provide a more reliable interface for resource files.



                 Additional data or source files which this test uses.
            """),
        } |
        cxx_common.raw_headers_arg() |
        cxx_common.include_directories_arg() |
        {
            "framework": attrs.option(attrs.enum(CxxTestType), default = None, doc = """
                Unused.
            """),
            "env": attrs.dict(key = attrs.string(), value = attrs.arg(), sorted = False, default = {}, doc = """
                A map of environment names and values to set when running the test.



                 It is also possible to expand references to other rules within the **values** of
                 these environment variables, using builtin `string parameter macros`
                :

                `$(location //path/to:target)`
                Expands to the location of the output of the build rule. This
                 means that you can refer to these without needing to be aware of how
                 Buck is storing data on the disk mid-build.
            """),
            "args": attrs.list(attrs.arg(), default = [], doc = """
                A list of additional arguments to pass to the test when it's run.



                 It is also possible to expand references to other rules within these
                 arguments, using builtin `string parameter macros`
                :

                `$(location //path/to:target)`
                Expands to the location of the output of the build rule. This
                 means that you can refer to these without needing to be aware of how
                 Buck is storing data on the disk mid-build.
            """),
        } |
        buck.run_test_separately_arg(run_test_separately_type = attrs.option(attrs.bool(), default = None)) |
        buck.test_rule_timeout_ms() |
        {
            "additional_coverage_targets": attrs.list(attrs.source(), default = []),
            "contacts": attrs.list(attrs.string(), default = []),
            "cxx_runtime_type": attrs.option(attrs.enum(CxxRuntimeType), default = None),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "default_platform": attrs.option(attrs.string(), default = None),
            "defaults": attrs.dict(key = attrs.string(), value = attrs.string(), sorted = False, default = {}),
            "deps": attrs.list(attrs.dep(), default = []),
            "devirt_enabled": attrs.bool(default = False),
            "executable_name": attrs.option(attrs.string(), default = None),
            "fat_lto": attrs.bool(default = False),
            "focused_list_target": attrs.option(attrs.dep(), default = None),
            "frameworks": attrs.list(attrs.string(), default = []),
            "header_namespace": attrs.option(attrs.string(), default = None),
            "headers_as_raw_headers_mode": attrs.option(attrs.enum(HeadersAsRawHeadersMode), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "lang_compiler_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.arg()), sorted = False, default = {}),
            "lang_platform_compiler_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg()))), sorted = False, default = {}),
            "lang_platform_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg()))), sorted = False, default = {}),
            "lang_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.arg()), sorted = False, default = {}),
            "libraries": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "link_deps_query_whole": attrs.bool(default = False),
            "link_group": attrs.option(attrs.string(), default = None),
            "link_group_map": attrs.option(attrs.list(attrs.tuple(attrs.string(), attrs.list(attrs.tuple(attrs.dep(), attrs.enum(Traversal), attrs.option(attrs.string()))))), default = None),
            "link_style": attrs.option(attrs.enum(LinkableDepType), default = None),
            "linker_extra_outputs": attrs.list(attrs.string(), default = []),
            "platform_compiler_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
            "platform_deps": attrs.list(attrs.tuple(attrs.regex(), attrs.set(attrs.dep(), sorted = True)), default = []),
            "platform_headers": attrs.list(attrs.tuple(attrs.regex(), attrs.named_set(attrs.source(), sorted = True)), default = []),
            "platform_linker_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg(anon_target_compatible = True))), default = []),
            "platform_preprocessor_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
            "platform_srcs": attrs.list(attrs.tuple(attrs.regex(), attrs.set(attrs.one_of(attrs.source(), attrs.tuple(attrs.source(), attrs.list(attrs.arg()))), sorted = True)), default = []),
            "post_linker_flags": attrs.list(attrs.arg(anon_target_compatible = True), default = []),
            "post_platform_linker_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg(anon_target_compatible = True))), default = []),
            "prefer_stripped_objects": attrs.bool(default = False),
            "prefix_header": attrs.option(attrs.source(), default = None),
            "thin_lto": attrs.bool(default = False),
            "use_default_test_main": attrs.option(attrs.bool(), default = None),
            "version_universe": attrs.option(attrs.string(), default = None),
            "weak_framework_names": attrs.list(attrs.string(), default = []),
        }
    ),
)

cxx_toolchain = prelude_rule(
    name = "cxx_toolchain",
    docs = "",
    examples = None,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "archive_contents": attrs.enum(ArchiveContents, default = "normal"),
            "archiver": attrs.source(),
            "archiver_flags": attrs.list(attrs.arg(), default = []),
            "archiver_type": attrs.enum(ArchiverProviderType),
            "asm_compiler": attrs.option(attrs.source(), default = None),
            "asm_compiler_flags": attrs.list(attrs.arg(), default = []),
            "asm_compiler_type": attrs.option(attrs.enum(CxxToolProviderType), default = None),
            "asm_preprocessor": attrs.option(attrs.source(), default = None),
            "asm_preprocessor_flags": attrs.list(attrs.arg(), default = []),
            "asm_preprocessor_type": attrs.option(attrs.enum(CxxToolProviderType), default = None),
            "assembler": attrs.source(),
            "assembler_flags": attrs.list(attrs.arg(), default = []),
            "assembler_preprocessor": attrs.option(attrs.source(), default = None),
            "assembler_preprocessor_flags": attrs.list(attrs.arg(), default = []),
            "assembler_preprocessor_type": attrs.option(attrs.enum(CxxToolProviderType), default = None),
            "assembler_type": attrs.option(attrs.enum(CxxToolProviderType), default = None),
            "binary_extension": attrs.option(attrs.string(), default = None),
            "c_compiler": attrs.source(),
            "c_compiler_flags": attrs.list(attrs.arg(), default = []),
            "c_compiler_type": attrs.option(attrs.enum(CxxToolProviderType), default = None),
            "c_preprocessor_flags": attrs.list(attrs.arg(), default = []),
            "cache_links": attrs.bool(default = False),
            "compiler_type": attrs.option(attrs.enum(CxxToolProviderType), default = None),
            "conflicting_header_basename_exemptions": attrs.set(attrs.string(), sorted = True, default = []),
            "contacts": attrs.list(attrs.string(), default = []),
            "cuda_compiler": attrs.option(attrs.source(), default = None),
            "cuda_compiler_flags": attrs.list(attrs.arg(), default = []),
            "cuda_compiler_type": attrs.option(attrs.enum(CxxToolProviderType), default = None),
            "cuda_preprocessor_flags": attrs.list(attrs.arg(), default = []),
            "cxx_compiler": attrs.source(),
            "cxx_compiler_flags": attrs.list(attrs.arg(), default = []),
            "cxx_compiler_type": attrs.option(attrs.enum(CxxToolProviderType), default = None),
            "cxx_preprocessor_flags": attrs.list(attrs.arg(), default = []),
            "debug_path_prefix_map_sanitizer_format": attrs.option(attrs.string(), default = None),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "detailed_untracked_header_messages": attrs.bool(default = False),
            "filepath_length_limited": attrs.bool(default = False),
            "headers_as_raw_headers_mode": attrs.option(attrs.enum(HeadersAsRawHeadersMode), default = None),
            "headers_whitelist": attrs.list(attrs.string(), default = []),
            "hip_compiler": attrs.option(attrs.source(), default = None),
            "hip_compiler_flags": attrs.list(attrs.arg(), default = []),
            "hip_compiler_type": attrs.option(attrs.enum(CxxToolProviderType), default = None),
            "hip_preprocessor_flags": attrs.list(attrs.arg(), default = []),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "link_path_normalization_args_enabled": attrs.bool(default = False),
            "linker": attrs.source(),
            "linker_flags": attrs.list(attrs.arg(anon_target_compatible = True), default = []),
            "linker_type": attrs.enum(LinkerProviderType),
            "nm": attrs.source(),
            "objcopy_for_shared_library_interface": attrs.source(),
            "objcopy_recalculates_layout": attrs.bool(default = False),
            "object_file_extension": attrs.string(default = ""),
            "pic_type_for_shared_linking": attrs.enum(PicType, default = "pic"),
            "private_headers_symlinks_enabled": attrs.bool(default = False),
            "public_headers_symlinks_enabled": attrs.bool(default = False),
            "ranlib": attrs.option(attrs.source(), default = None),
            "ranlib_flags": attrs.list(attrs.arg(), default = []),
            "requires_archives": attrs.bool(default = False),
            "shared_dep_runtime_ld_flags": attrs.list(attrs.arg(), default = []),
            "shared_library_extension": attrs.string(default = ""),
            "shared_library_interface_flags": attrs.list(attrs.string(), default = []),
            "shared_library_interface_type": attrs.enum(SharedLibraryInterfaceParamsType),
            "shared_library_versioned_extension_format": attrs.string(default = ""),
            "static_dep_runtime_ld_flags": attrs.list(attrs.arg(), default = []),
            "static_library_extension": attrs.string(default = ""),
            "static_pic_dep_runtime_ld_flags": attrs.list(attrs.arg(), default = []),
            "strip": attrs.source(),
            "strip_all_flags": attrs.option(attrs.list(attrs.arg()), default = None),
            "strip_debug_flags": attrs.option(attrs.list(attrs.arg()), default = None),
            "strip_non_global_flags": attrs.option(attrs.list(attrs.arg()), default = None),
            "use_arg_file": attrs.bool(default = False),
            "use_header_map": attrs.bool(default = False),
        }
    ),
)

prebuilt_cxx_library = prelude_rule(
    name = "prebuilt_cxx_library",
    docs = """
        A `prebuilt_cxx_library()` rule represents a set of native libraries and C/C++ header
        files and provides various flags to control how they are linked and exported.
    """,
    examples = """
        A prebuilt library containing only headers that other libraries may need.


        ```

        prebuilt_cxx_library(
          name = 'stdutil',
          header_only = True,
          header_dirs = [
            'include',
          ],
        )

        ```

         A prebuilt library with static and shared libs.


        ```

        prebuilt_cxx_library(
          name = 'mylib',
          soname = 'libmylib.so',
          static_lib = 'libmylib.a',
          static_pic_lib = 'libmylib_pic.a',
          shared_lib = 'libmylib.so',
          exported_headers = [
            'mylib.h',
          ],
        )

        ```

         A prebuilt library with multiple builds for multiple platforms.


        ```

        prebuilt_cxx_library(
          name = 'mylib',
          soname = 'libmylib.so',
          platform_shared_lib = [
            ('android-arm', 'android-arm/libmylib.so'),
            ('android-x86', 'android-x86/libmylib.so'),
            ('iphonesimulator-x86_64', 'iphonesimulator-x86_64/libmylib.so'),
          ],
          platform_static_lib = [
            ('android-arm', 'android-arm/libmylib.a'),
            ('android-x86', 'android-x86/libmylib.a'),
            ('iphonesimulator-x86_64', 'iphonesimulator-x86_64/libmylib.a'),
          ],
          exported_headers = [
            'mylib.h',
          ],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "header_only": attrs.bool(default = False, doc = """
                Indicates if this library only consists of headers or not. If this is set to
                 `True`, Buck will not link this library into any library that depends on it.
            """),
            "header_dirs": attrs.option(attrs.list(attrs.source()), default = None, doc = """
                A directory that headers can be included from. These directories are added
                 to the include path using `-isystem`.
            """),
            "platform_header_dirs": attrs.option(attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.source()))), default = None, doc = """
                Platform specific header directories. These should be specified as a list of pairs where the first
                 element is an un-anchored regex (in java.util.regex.Pattern syntax) against which the platform
                 name is matched, and the second element is either a list of header directories.
                 See `header_dirs` for more information.
            """),
            "static_lib": attrs.option(attrs.source(), default = None, doc = """
                The path to the library to use when performing static linking.
            """),
            "platform_static_lib": attrs.option(attrs.list(attrs.tuple(attrs.regex(), attrs.source())), default = None, doc = """
                Platform specific static library. These should be specified as a list of pairs where the first
                 element is an un-anchored regex (in java.util.regex.Pattern syntax) against which the platform
                 name is matched, and the second element the path to the library.
                 See `static_lib` for more information.
            """),
            "static_pic_lib": attrs.option(attrs.source(), default = None, doc = """
                The path to the library to use when performing static PIC linking.
            """),
            "platform_static_pic_lib": attrs.option(attrs.list(attrs.tuple(attrs.regex(), attrs.source())), default = None, doc = """
                Platform specific static PIC library. These should be specified as a list of pairs where the first
                 element is an un-anchored regex (in java.util.regex.Pattern syntax) against which the platform
                 name is matched, and the second element the path to the library.
                 See `static_pic_lib` for more information.
            """),
            "shared_lib": attrs.option(attrs.source(), default = None, doc = """
                The path to the library to use when performing shared linking.
            """),
            "platform_shared_lib": attrs.option(attrs.list(attrs.tuple(attrs.regex(), attrs.source())), default = None, doc = """
                Platform specific shared library. These should be specified as a list of pairs where the first
                 element is an un-anchored regex (in java.util.regex.Pattern syntax) against which the platform
                 name is matched, and the second element the path to the library.
                 See `shared_lib` for more information.
            """),
        } |
        cxx_common.supported_platforms_regex_arg() |
        cxx_common.exported_headers_arg() |
        cxx_common.exported_platform_headers_arg() |
        cxx_common.header_namespace_arg() |
        cxx_common.exported_preprocessor_flags_arg(exported_preprocessor_flags_type = attrs.list(attrs.arg(), default = [])) |
        cxx_common.exported_platform_preprocessor_flags_arg() |
        cxx_common.exported_linker_flags_arg() |
        cxx_common.force_static(force_static_type = attrs.bool(default = False)) |
        native_common.preferred_linkage(preferred_linkage_type = attrs.option(attrs.enum(Linkage), default = None)) |
        cxx_common.exported_deps_arg() |
        cxx_common.exported_platform_deps_arg() |
        cxx_common.supports_merged_linking() |
        {
            "can_be_asset": attrs.bool(default = False),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "deps": attrs.list(attrs.dep(), default = []),
            "exported_lang_platform_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg()))), sorted = False, default = {}),
            "exported_lang_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.arg()), sorted = False, default = {}),
            "exported_platform_linker_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg(anon_target_compatible = True))), default = []),
            "exported_post_linker_flags": attrs.list(attrs.arg(anon_target_compatible = True), default = []),
            "exported_post_platform_linker_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg(anon_target_compatible = True))), default = []),
            "frameworks": attrs.list(attrs.string(), default = []),
            "import_lib": attrs.option(attrs.source(), default = None),
            "include_in_android_merge_map_output": attrs.bool(default = False),
            "labels": attrs.list(attrs.string(), default = []),
            "libraries": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "link_whole": attrs.bool(default = False),
            "link_without_soname": attrs.bool(default = False),
            "platform_import_lib": attrs.option(attrs.list(attrs.tuple(attrs.regex(), attrs.source())), default = None),
            "provided": attrs.bool(default = False),
            "soname": attrs.option(attrs.string(), default = None),
            "supports_shared_library_interface": attrs.bool(default = False),
            "versioned_exported_lang_platform_preprocessor_flags": attrs.versioned(attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg()))), sorted = False)),
            "versioned_exported_lang_preprocessor_flags": attrs.versioned(attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.arg()), sorted = False)),
            "versioned_exported_platform_preprocessor_flags": attrs.versioned(attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())))),
            "versioned_exported_preprocessor_flags": attrs.versioned(attrs.list(attrs.arg())),
            "versioned_header_dirs": attrs.option(attrs.versioned(attrs.list(attrs.source())), default = None),
            "versioned_import_lib": attrs.option(attrs.versioned(attrs.source()), default = None),
            "versioned_shared_lib": attrs.option(attrs.versioned(attrs.source()), default = None),
            "versioned_soname": attrs.option(attrs.versioned(attrs.string()), default = None),
            "versioned_static_lib": attrs.option(attrs.versioned(attrs.source()), default = None),
            "versioned_static_pic_lib": attrs.option(attrs.versioned(attrs.source()), default = None),
        }
    ),
)

prebuilt_cxx_library_group = prelude_rule(
    name = "prebuilt_cxx_library_group",
    docs = """
        A `prebuilt_cxx_library_group()` rule represents a group of native libraries which should
        be handled together in a single rule, perhaps using special link-line construction.
    """,
    examples = """
        A prebuilt library group wrapping two libraries that must be linked together.


        ```

        prebuilt_cxx_library_group(
          name = 'util',
          static_link = [
            '-Wl,--start-group',
            '$(lib 0)',
            '$(lib 1)',
            '-Wl,--end-group',
          ],
          static_libs = [
            'lib/liba.a',
            'lib/libb.a',
          ],
          static_pic_link = [
            '-Wl,--start-group',
            '$(lib 0)',
            '$(lib 1)',
            '-Wl,--end-group',
          ],
          static_libs = [
            'lib/liba_pic.a',
            'lib/libb_pic.a',
          ],
          shared_link = [
            '$(rel-lib liba.so)',
            '$(rel-lib libb.so)',
          ],
          shared_libs = {
            'liba.so': 'lib/liba.so',
          },
          provided_shared_libs = {
            'libb.so': 'lib/libb.so',
          },
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        cxx_common.exported_preprocessor_flags_arg(exported_preprocessor_flags_type = attrs.list(attrs.string(), default = [])) |
        {
            "static_link": attrs.list(attrs.string(), default = [], doc = """
                The arguments to use when linking this library group using the static link style.
                 The actual paths to libraries should be listed in the `static_libs` parameter,
                 and referenced via the the `$(lib [index])` macro in these args.
            """),
            "static_libs": attrs.list(attrs.source(), default = [], doc = """
                The paths to the libraries used when using the static link style.
                 The `static_link` parameter should refer to these libs using their index
                 number.
            """),
            "static_pic_link": attrs.list(attrs.string(), default = [], doc = """
                The arguments to use when linking this library group using the static-pic link style.
                 The actual paths to libraries should be listed in the `static_pic_libs`
                 parameter, and referenced via the the `$(lib [index])` macro in
                 these args.
            """),
            "static_pic_libs": attrs.list(attrs.source(), default = [], doc = """
                The paths to the libraries used when using the static link style.
                 The `static_pic_link` parameter should refer to these libs using their
                 index number.
            """),
            "shared_link": attrs.list(attrs.string(), default = [], doc = """
                The arguments to use when linking this library group using the shared link style.
                 The actual paths to libraries should be listed in the `shared_libs`
                 parameter, and referenced via the the `$(lib [name])` macro (or the
                 `$(rel-lib [name])` macro, when the shared library should be linked
                 using the `-L[dir] -l[name]` style) in these args.
            """),
            "shared_libs": attrs.dict(key = attrs.string(), value = attrs.source(), sorted = False, default = {}, doc = """
                The map of shared library names to paths used when using the shared link style.
                 The `shared_link` parameter should refer to these libs using their library
                 name.
            """),
            "provided_shared_libs": attrs.dict(key = attrs.string(), value = attrs.source(), sorted = False, default = {}, doc = """
                The map of system-provided shared library names to paths used when using the shared link style.
                 The `shared_link` parameter should refer to these libs using their library name.
            """),
        } |
        cxx_common.exported_deps_arg() |
        cxx_common.exported_platform_deps_arg() |
        {
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "deps": attrs.list(attrs.dep(), default = []),
            "import_libs": attrs.dict(key = attrs.string(), value = attrs.source(), sorted = False, default = {}),
            "include_dirs": attrs.list(attrs.source(), default = []),
            "include_in_android_merge_map_output": attrs.bool(default = False),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "supported_platforms_regex": attrs.option(attrs.regex(), default = None),
        }
    ),
)

llvm_link_bitcode = prelude_rule(
    name = "llvm_link_bitcode",
    docs = """
        A llvm\\_link\\_bitcode() rule builds a LLVM bitcode object from a given set LLVM bitcode inputs.
    """,
    examples = """
        ```

        # A rule that builds and runs C/C++ test using gtest.
        llvm_link_bitcode(
          name = 'echo_test',
          srcs = [
            'echo_test.o',  // Where this is a LLVM bitcode object.
            'echo_other.o', // And this is another LLVM bitcode object.
          ],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        cxx_common.srcs_arg() |
        buck.deps_query_arg() |
        {
            "deps": attrs.list(attrs.dep(), default = []),
        }
    ),
)

cxx_rules = struct(
    cxx_binary = cxx_binary,
    cxx_genrule = cxx_genrule,
    cxx_library = cxx_library,
    cxx_precompiled_header = cxx_precompiled_header,
    cxx_test = cxx_test,
    cxx_toolchain = cxx_toolchain,
    prebuilt_cxx_library = prebuilt_cxx_library,
    prebuilt_cxx_library_group = prebuilt_cxx_library_group,
    llvm_link_bitcode = llvm_link_bitcode,
)
