# Copyright (c) Meta Platforms, Inc. and affiliates.
#
# This source code is licensed under both the MIT license found in the
# LICENSE-MIT file in the root directory of this source tree and the Apache
# License, Version 2.0 found in the LICENSE-APACHE file in the root directory
# of this source tree.

# TODO(cjhopman): This was generated by scripts/hacks/rules_shim_with_docs.py,
# but should be manually edited going forward. There may be some errors in
# the generated docs, and so those should be verified to be accurate and
# well-formatted (and then delete this TODO)

def _deps_arg():
    return {
        "deps": attrs.list(attrs.dep(), default = [], doc = """
    The set of dependencies of this rule.
     Each element should be a string specifying a d\\_library rule defined elsewhere
     (e.g. `':foo'` or '//foo:bar').
"""),
    }

def _srcs_arg():
    return {
        "srcs": attrs.named_set(attrs.source(), sorted = True, default = [], doc = """
    The set of D source files to be compiled by this rule.
     Each element should be a string specifying a source file (e.g. `'foo/bar.d'`).
"""),
    }

def _linker_flags_arg():
    return {
        "linker_flags": attrs.list(attrs.string(), default = [], doc = """
    The list of flags to be passed to the linker.
     Each element should be a string specifying a linker flag (e.g. `'--as-needed'`).
"""),
    }

d_common = struct(
    deps_arg = _deps_arg,
    srcs_arg = _srcs_arg,
    linker_flags_arg = _linker_flags_arg,
)
