# Copyright (c) Meta Platforms, Inc. and affiliates.
#
# This source code is licensed under both the MIT license found in the
# LICENSE-MIT file in the root directory of this source tree and the Apache
# License, Version 2.0 found in the LICENSE-APACHE file in the root directory
# of this source tree.

# TODO(cjhopman): This was generated by scripts/hacks/rules_shim_with_docs.py,
# but should be manually edited going forward. There may be some errors in
# the generated docs, and so those should be verified to be accurate and
# well-formatted (and then delete this TODO)

load(":common.bzl", "buck", "prelude_rule")
load(":d_common.bzl", "d_common")

d_binary = prelude_rule(
    name = "d_binary",
    docs = """
        A d\\_binary() rule builds a native executable from the supplied set of D source
        files and dependencies.
    """,
    examples = """
        ```

        # A rule that builds a D native executable from a single .d file
        # and a library dependency.
        d_binary(
          name='greet',
          srcs=[
            'greet.d',
          ],
          deps=[
            ':greeting',
          ],
        )

        d_library(
          name='greeting',
          srcs=[
            'greeting.d',
          ],
          deps=[
            ':join',
          ],
        )

        d_library(
          name='join',
          srcs=[
            'join.d',
          ],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        d_common.srcs_arg() |
        d_common.deps_arg() |
        d_common.linker_flags_arg() |
        {
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
        }
    ),
)

d_library = prelude_rule(
    name = "d_library",
    docs = """
        A d\\_library() rule represents a set of D source files.
    """,
    examples = """
        ```

        # A simple library with a single source file and a single dependency.
        d_library(
          name='greeting',
          srcs=[
            'greeting.d',
          ],
          deps=[
            ':join',
          ],
        )

        d_library(
          name='join',
          srcs=[
            'join.d',
          ],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        d_common.srcs_arg() |
        d_common.deps_arg() |
        {
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "linker_flags": attrs.list(attrs.string(), default = []),
        }
    ),
)

d_test = prelude_rule(
    name = "d_test",
    docs = """
        A `d_test()` rule is used to define a set of D source
        files that contain tests to run via D's unittest support. The source code of the test
        must provide a main() function.
    """,
    examples = """
        ```

        # A rule that builds and runs D test with a single source file.
        d_test(
          name = 'test',
          srcs = [
            'test.d',
          ],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        d_common.srcs_arg() |
        {
            "labels": attrs.list(attrs.string(), default = [], doc = """
                A list of labels to be applied to these tests. These labels are
                 arbitrary text strings and have no meaning within buck itself. They
                 can, however, have meaning for you as a test author
                 (e.g., `smoke` or `fast`). A label can be
                 used to filter or include a specific `d_test()` rule
                 when executing `buck test`
            """),
        } |
        buck.test_rule_timeout_ms() |
        d_common.deps_arg() |
        {
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "licenses": attrs.list(attrs.source(), default = []),
            "linker_flags": attrs.list(attrs.string(), default = []),
        }
    ),
)

d_rules = struct(
    d_binary = d_binary,
    d_library = d_library,
    d_test = d_test,
)
