# Copyright (c) Meta Platforms, Inc. and affiliates.
#
# This source code is licensed under both the MIT license found in the
# LICENSE-MIT file in the root directory of this source tree and the Apache
# License, Version 2.0 found in the LICENSE-APACHE file in the root directory
# of this source tree.

# TODO(cjhopman): This was generated by scripts/hacks/rules_shim_with_docs.py,
# but should be manually edited going forward. There may be some errors in
# the generated docs, and so those should be verified to be accurate and
# well-formatted (and then delete this TODO)

load(":common.bzl", "prelude_rule")

FrameworkVersion = ["net35", "net40", "net45", "net46"]

csharp_library = prelude_rule(
    name = "csharp_library",
    docs = """
        A csharp\\_library() rule builds a .Net library from the supplied set of C# source files
         and dependencies by invoking csc.
    """,
    examples = """
        For more examples, check out our [integration tests](https://github.com/facebook/buck/tree/dev/test/com/facebook/buck/rust/testdata/).


        ```

        csharp_library(
          name = 'simple',
          dll_name = 'Cake.dll',
          framework_ver = 'net46',
          srcs = [
            'Hello.cs',
          ],
          resources = {
            'greeting.txt': '//some:target',
          },
          deps=[
            ':other',
            'System.dll',
          ],
        )

        prebuilt_dotnet_library(
          name = 'other',
          assembly = 'other-1.0.dll',
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "dll_name": attrs.string(default = "", doc = """
                The output name of the dll. This allows you to specify the name of
                 the dll exactly. When this is not set, the dll will be named after
                 the short name of the target.
            """),
            "srcs": attrs.list(attrs.source(), default = [], doc = """
                The collection of source files to compile.
            """),
            "resources": attrs.dict(key = attrs.string(), value = attrs.source(), sorted = False, default = {}, doc = """
                Resources that should be embedded within the built DLL. The format
                 is the name of the resource once mapped into the DLL as the key, and
                 the value being the resource that should be merged. This allows
                 non-unique keys to be identified quickly.
            """),
            "framework_ver": attrs.enum(FrameworkVersion, doc = """
                The version of the .Net framework that this library targets. This is
                 one of 'net35', 'net40', 'net45' and 'net46'.
            """),
            "deps": attrs.list(attrs.one_of(attrs.dep(), attrs.string()), default = [], doc = """
                The set of targets or system-provided assemblies to rely on. Any
                 values that are targets must be either csharp\\_library or `prebuilt_dotnet_library`
                 instances.
            """),
            "compiler_flags": attrs.list(attrs.string(), default = [], doc = """
                The set of additional compiler flags to pass to the compiler.
            """),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
        }
    ),
)

prebuilt_dotnet_library = prelude_rule(
    name = "prebuilt_dotnet_library",
    docs = """
        A `prebuilt_dotnet_library()` rule is used to include
        prebuilt .Net assembles into your .Net code.
    """,
    examples = """
        ```

        prebuilt_dotnet_library(
          name = 'log4net',
          assembly = 'log4net.dll',
        )

        csharp_library(
          name = 'example',
          srcs = [
            'Hello.cs',
          ],
          framework_ver = 'net46',
          deps = [
            ':log4net',
            'System.dll',
          ],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "assembly": attrs.source(doc = """
                The path to the DLL that this rule provides.
            """),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
        }
    ),
)

dotnet_rules = struct(
    csharp_library = csharp_library,
    prebuilt_dotnet_library = prebuilt_dotnet_library,
)
