# Copyright (c) Meta Platforms, Inc. and affiliates.
#
# This source code is licensed under both the MIT license found in the
# LICENSE-MIT file in the root directory of this source tree and the Apache
# License, Version 2.0 found in the LICENSE-APACHE file in the root directory
# of this source tree.

# TODO(cjhopman): This was generated by scripts/hacks/rules_shim_with_docs.py,
# but should be manually edited going forward. There may be some errors in
# the generated docs, and so those should be verified to be accurate and
# well-formatted (and then delete this TODO)

load(":common.bzl", "CxxRuntimeType", "CxxSourceType", "HeadersAsRawHeadersMode", "Traversal", "buck", "prelude_rule")
load(":cxx_common.bzl", "cxx_common")
load(":go_common.bzl", "go_common")
load(":native_common.bzl", "native_common")

BuildMode = ["executable", "c_shared", "c_archive"]

GoTestCoverStepMode = ["set", "count", "atomic", "none"]

cgo_library = prelude_rule(
    name = "cgo_library",
    docs = """
        A cgo\\_library() rule builds an object from the supplied set of Go/C source files and
        dependencies. The outputs are linked into go executable in the last step (compile).

        The 'go build' command would collect the cgo directives from the source files, however
        with buck the flags needs to be passed in the cgo\\_library manually

        This rule borrows from `cxx\\_binary()`since C/C++ sources are being compiled.
    """,
    examples = """
        ```

        # A rule that builds a Go native executable with linked cgo library based on
        # C/C++ util library.
        go_binary(
            name = "bin",
            srcs = ["main.go"],
            deps = [":lib"]
        )

        cgo_library(
            name = "lib",
            srcs = ["cgo_source.go"],
            deps = [":util"],
        )

        cxx_library(
            name = "util",
            srcs = ["util.c"],
            headers = ["util.h"],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        go_common.package_name_arg() |
        {
            "srcs": attrs.list(attrs.one_of(attrs.source(), attrs.tuple(attrs.source(), attrs.list(attrs.arg()))), default = [], doc = """
                The set of source files to be compiled by this rule. .go files will be compiled with the CGO
                 compiler. Each file needs to have `import "C"` declared.
            """),
            "go_srcs": attrs.list(attrs.source(), default = [], doc = """
                The set of source files to be compiled by this rule. Go (`.go`) files are compiled with the Go
                 compiler. In contrast to the `srcs` argument, these files *cannot* have `import "C"` declared.
            """),
        } |
        cxx_common.headers_arg() |
        cxx_common.preprocessor_flags_arg() |
        cxx_common.platform_preprocessor_flags_arg() |
        go_common.cgo_compiler_flags_arg() |
        go_common.embedcfg_arg() |
        cxx_common.compiler_flags_arg() |
        cxx_common.platform_compiler_flags_arg() |
        cxx_common.linker_extra_outputs_arg() |
        cxx_common.linker_flags_arg() |
        cxx_common.platform_linker_flags_arg() |
        native_common.link_style() |
        cxx_common.raw_headers_arg() |
        {
            "go_compiler_flags": attrs.list(attrs.string(), default = [], doc = """
                The set of additional compiler flags to pass to `go tool compile`.
            """),
            "go_assembler_flags": attrs.list(attrs.string(), default = [], doc = """
                The set of additional assembler flags to pass to `go tool asm`.
            """),
            "contacts": attrs.list(attrs.string(), default = []),
            "cxx_runtime_type": attrs.option(attrs.enum(CxxRuntimeType), default = None),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "default_platform": attrs.option(attrs.string(), default = None),
            "defaults": attrs.dict(key = attrs.string(), value = attrs.string(), sorted = False, default = {}),
            "deps": attrs.list(attrs.dep(), default = []),
            "deps_query": attrs.option(attrs.query(), default = None),
            "devirt_enabled": attrs.bool(default = False),
            "executable_name": attrs.option(attrs.string(), default = None),
            "exported_deps": attrs.list(attrs.dep(), default = []),
            "fat_lto": attrs.bool(default = False),
            "focused_list_target": attrs.option(attrs.dep(), default = None),
            "frameworks": attrs.list(attrs.string(), default = []),
            "header_namespace": attrs.option(attrs.string(), default = None),
            "headers_as_raw_headers_mode": attrs.option(attrs.enum(HeadersAsRawHeadersMode), default = None),
            "include_directories": attrs.set(attrs.string(), sorted = True, default = []),
            "labels": attrs.list(attrs.string(), default = []),
            "lang_compiler_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.arg()), sorted = False, default = {}),
            "lang_platform_compiler_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg()))), sorted = False, default = {}),
            "lang_platform_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg()))), sorted = False, default = {}),
            "lang_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.arg()), sorted = False, default = {}),
            "libraries": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "link_deps_query_whole": attrs.bool(default = False),
            "link_group": attrs.option(attrs.string(), default = None),
            "link_group_map": attrs.option(attrs.list(attrs.tuple(attrs.string(), attrs.list(attrs.tuple(attrs.dep(), attrs.enum(Traversal), attrs.option(attrs.string()))))), default = None),
            "platform_deps": attrs.list(attrs.tuple(attrs.regex(), attrs.set(attrs.dep(), sorted = True)), default = []),
            "platform_headers": attrs.list(attrs.tuple(attrs.regex(), attrs.named_set(attrs.source(), sorted = True)), default = []),
            "platform_srcs": attrs.list(attrs.tuple(attrs.regex(), attrs.set(attrs.one_of(attrs.source(), attrs.tuple(attrs.source(), attrs.list(attrs.arg()))), sorted = True)), default = []),
            "post_linker_flags": attrs.list(attrs.arg(), default = []),
            "post_platform_linker_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
            "precompiled_header": attrs.option(attrs.source(), default = None),
            "prefer_stripped_objects": attrs.bool(default = False),
            "prefix_header": attrs.option(attrs.source(), default = None),
            "thin_lto": attrs.bool(default = False),
            "version_universe": attrs.option(attrs.string(), default = None),
            "weak_framework_names": attrs.list(attrs.string(), default = []),
        }
    ),
)

go_binary = prelude_rule(
    name = "go_binary",
    docs = """
        A go\\_binary() rule builds a native executable from the supplied set of Go source files
         and dependencies. The files supplied are expected to be in the main package, implicitly.
    """,
    examples = """
        For more examples, check out our [integration tests](https://github.com/facebook/buck/tree/dev/test/com/facebook/buck/features/go/testdata).


        ```

        go_binary(
          name='greet',
          srcs=[
            'main.go',
          ],
          deps=[
            ':greeting',
          ],
        )

        go_library(
          name='greeting',
          srcs=[
            'greeting.go',
          ],
          deps=[
            ':join',
          ],
        )

        go_library(
          name='join',
          srcs=[
            'join.go',
          ],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        go_common.srcs_arg() |
        go_common.deps_arg() |
        go_common.link_style_arg() |
        go_common.link_mode_arg() |
        go_common.compiler_flags_arg() |
        go_common.assembler_flags_arg() |
        go_common.linker_flags_arg() |
        go_common.external_linker_flags_arg() |
        go_common.embedcfg_arg() |
        {
            "resources": attrs.list(attrs.source(), default = [], doc = """
                Static files to be symlinked into the working directory of the test. You can access these in your
                 by opening the files as relative paths, e.g. `ioutil.ReadFile("testdata/input")`.
            """),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "platform": attrs.option(attrs.string(), default = None),
            "platform_external_linker_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
        }
    ),
)

go_exported_library = prelude_rule(
    name = "go_exported_library",
    docs = """
        A go\\_exported\\_library() rule builds a C library from the supplied set of Go source files
         and dependencies. This is done via `-buildmode` flag and "//export" annotations in the code.
    """,
    examples = """
        For more examples, check out our [integration tests](https://github.com/facebook/buck/tree/dev/test/com/facebook/buck/features/go/testdata).


        ```

        go_exported_library(
            name = "shared",
            srcs = ["main.go"],
            build_mode = "c_shared",
            compiler_flags = ["-shared"],
            deps = [":example"],
        )

        cgo_library(
            name = "example",
            package_name = "cgo",
            srcs = [
                "export-to-c.go",  # file with //export annotations
            ],
            cgo_compiler_flags = [],
            compiler_flags = [],
            headers = [],
        )

        cxx_genrule(
            name = "cgo_exported_headers",
            out = "includes",
            cmd = (
                "mkdir -p $OUT && " +
                "cat `dirname $(location :shared)`/includes/*.h > $OUT/_cgo_export.h"
            ),
        )

        prebuilt_cxx_library(
            name = "cxx_so_with_header",
            header_dirs = [":cgo_exported_headers"],
            shared_lib = ":shared",
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        go_common.srcs_arg() |
        go_common.deps_arg() |
        {
            "build_mode": attrs.enum(BuildMode, doc = """
                Determines the build mode (equivalent of `-buildmode`). Can be
                 one of the following values: `c_archive`, `c_shared`.
                 This argument is valid only if at there is at least one `cgo_library declared in deps.
                 In addition you should make sure that `-shared` flag is added to `compiler_flags`
                 and go version under `go.goroot` is compiled with that flag present in:
                 `gcflags`, `ldflags` and `asmflags``
            """),
        } |
        go_common.link_style_arg() |
        go_common.link_mode_arg() |
        go_common.compiler_flags_arg() |
        go_common.assembler_flags_arg() |
        go_common.linker_flags_arg() |
        go_common.external_linker_flags_arg() |
        {
            "resources": attrs.list(attrs.source(), default = [], doc = """
                Static files to be symlinked into the working directory of the test. You can access these in your
                 by opening the files as relative paths, e.g. `ioutil.ReadFile("testdata/input")`.
            """),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "embedcfg": attrs.option(attrs.source(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "platform": attrs.option(attrs.string(), default = None),
            "platform_external_linker_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
        }
    ),
)

go_library = prelude_rule(
    name = "go_library",
    docs = """
        A go\\_library() rule builds a native library from the supplied set of Go source files
         and dependencies.
    """,
    examples = """
        For more examples, check out our [integration tests](https://github.com/facebook/buck/tree/dev/test/com/facebook/buck/features/go/testdata).


        ```

        go_library(
          name='greeting',
          srcs=[
            'greeting.go',
          ],
          deps=[
            ':join',
          ],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        go_common.srcs_arg() |
        go_common.package_name_arg() |
        go_common.deps_arg() |
        go_common.compiler_flags_arg() |
        go_common.assembler_flags_arg() |
        go_common.embedcfg_arg() |
        {
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "exported_deps": attrs.list(attrs.dep(), default = []),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
        }
    ),
)

go_test = prelude_rule(
    name = "go_test",
    docs = """
        A `go_test()` rule builds a native binary from the
         specified Go source and resource files—and a generated main file. It's
         similar to the `go test` command.


         If your test requires static files you should specify these in
         the **resources** argument. If you do not specify these
         files, they won't be available when your test runs.
    """,
    examples = """
        For more examples, check out our [integration tests](https://github.com/facebook/buck/tree/dev/test/com/facebook/buck/features/go/testdata).


        ```

        go_library(
          name='greeting',
          srcs=[
            'greeting.go',
          ],
          deps=[
            ':join',
          ],
        )

        go_test(
          name='greeting-test',
          srcs=[
            'greeting_ext_test.go',
          ],
          deps=[
            ':greeting'
          ],
        )

        go_test(
          name='greeting-internal-test',
          package_name='greeting',
          srcs=[
            'greeting.go',
            'greeting_test.go',
          ],
          deps=[
            ':join',
          ],
        )

        # Or

        go_test(
          name='greeting-better-internal-test',
          srcs=['greeting_test.go'],
          library=':greeting',
        )


        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        go_common.srcs_arg() |
        {
            "library": attrs.option(attrs.dep(), default = None, doc = """
                Specify the library that this internal test is testing. This will copy the `srcs`,
                 `package_name` and `deps` from the target specified so you don't have
                 to duplicate them.
            """),
            "package_name": attrs.option(attrs.string(), default = None, doc = """
                Sets the full name of the test package being compiled. This defaults to the path from the buck
                 root with "\\_test" appended. (e.g. given a ./.buckconfig, a rule in ./a/b/BUCK defaults to package "a/b\\_test")

                 Note: if you want to test packages internally (i.e. same package name), use the `library`
                 parameter instead of setting `package_name` to include the tested source files.
            """),
            "coverage_mode": attrs.option(attrs.enum(GoTestCoverStepMode), default = None, doc = """
                Test coverage functionality will be included in the executable. Modes: set, count, atomic
            """),
        } |
        go_common.deps_arg() |
        go_common.link_style_arg() |
        go_common.link_mode_arg() |
        go_common.compiler_flags_arg() |
        go_common.assembler_flags_arg() |
        go_common.linker_flags_arg() |
        go_common.external_linker_flags_arg() |
        go_common.embedcfg_arg() |
        {
            "resources": attrs.list(attrs.source(), default = [], doc = """
                Static files that are symlinked into the working directory of the
                 test. You can access these files in your test by opening them using
                 relative paths, such as `ioutil.ReadFile("testdata/input")`.
            """),
        } |
        buck.test_label_arg() |
        buck.test_rule_timeout_ms() |
        {
            "env": attrs.dict(key = attrs.string(), value = attrs.arg(), sorted = False, default = {}, doc = """
                A map of environment variables and values to set when running the test.
            """),
        } |
        buck.run_test_separately_arg(run_test_separately_type = attrs.bool(default = False)) |
        {
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "licenses": attrs.list(attrs.source(), default = []),
            "platform": attrs.option(attrs.string(), default = None),
            "runner": attrs.option(attrs.dep(), default = None),
            "specs": attrs.option(attrs.arg(json = True), default = None),
        }
    ),
)

go_test_runner = prelude_rule(
    name = "go_test_runner",
    docs = "",
    examples = None,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "test_runner_generator": attrs.source(),
        }
    ),
)

prebuilt_go_library = prelude_rule(
    name = "prebuilt_go_library",
    docs = """
        A prebuilt\\_go\\_library() rule provides a native library from the specified file.
    """,
    examples = """
        For more examples, check out our [integration tests](https://github.com/facebook/buck/tree/dev/test/com/facebook/buck/features/go/testdata).


        ```

        prebuilt_go_library(
          name='greeting',
          package_name='greeting',
          library='greeting.a',
          deps=[
            ':join',
          ],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "library": attrs.source(doc = """
                Path to the precompiled Go library - typically of the form 'foo.a'.
            """),
        } |
        go_common.package_name_arg() |
        go_common.deps_arg() |
        {
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "exported_deps": attrs.list(attrs.dep(), default = []),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
        }
    ),
)

go_rules = struct(
    cgo_library = cgo_library,
    go_binary = go_binary,
    go_exported_library = go_exported_library,
    go_library = go_library,
    go_test = go_test,
    go_test_runner = go_test_runner,
    prebuilt_go_library = prebuilt_go_library,
)
