# Copyright (c) Meta Platforms, Inc. and affiliates.
#
# This source code is licensed under both the MIT license found in the
# LICENSE-MIT file in the root directory of this source tree and the Apache
# License, Version 2.0 found in the LICENSE-APACHE file in the root directory
# of this source tree.

# TODO(cjhopman): This was generated by scripts/hacks/rules_shim_with_docs.py,
# but should be manually edited going forward. There may be some errors in
# the generated docs, and so those should be verified to be accurate and
# well-formatted (and then delete this TODO)

load(":common.bzl", "CxxRuntimeType", "CxxSourceType", "HeadersAsRawHeadersMode", "LinkableDepType", "Traversal", "prelude_rule")
load(":cxx_common.bzl", "cxx_common")

halide_library = prelude_rule(
    name = "halide_library",
    docs = """
        A halide\\_library() rule represents a set of Halide sources, along with the "compiler"
        code needed to compile them into object format (see [the Halide site](http://halide-lang.org) for information about Halide and about static compilation of
        Halide pipelines). The object code will be generated for the target architecture.
    """,
    examples = """
        ```

        halide_library(
          # Your library name.
          name = 'brighter',

          # Your pipeline + compiler sources.
          srcs = ['halide/main.cpp'],

          # Any dependencies for your compiler. Note that targets that depend on
          # this rule WILL NOT include or link the output(s) of these targets.
          compiler_deps = [
            # You'll need libHalide to use this rule; in our example, we assume it's
            # located in the 'third-party/halide' directory.
            '//third-party/halide:halide'
          ],

          # Any dependencies for your generated shader. Targets that depend on this
          # rule will include and/or link the output(s) of these targets.
          deps = [
            # ...
          ],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "srcs": attrs.list(attrs.one_of(attrs.source(), attrs.tuple(attrs.source(), attrs.list(attrs.arg()))), default = [], doc = """
                The set of halide sources to compile for this rule. The sources will be
                 compiled and linked for the host architecture, and the resulting binary will
                 be run to produce the object code for the Halide pipeline.
            """),
            "deps": attrs.list(attrs.dep(), default = [], doc = """
                The dependencies of the generated halide pipeline code. This is useful if, for
                 example, your pipeline calls an external function using Halide::Func::define\\_extern.
            """),
            "compiler_deps": attrs.list(attrs.dep(), default = [], doc = """
                The dependencies of the halide compiler itself. Targets that depend on the
                 halide\\_library rule will not include or link the outputs of these targets.
            """),
        } |
        cxx_common.compiler_flags_arg() |
        cxx_common.platform_compiler_flags_arg() |
        cxx_common.linker_flags_arg() |
        cxx_common.platform_linker_flags_arg() |
        cxx_common.supported_platforms_regex_arg() |
        {
            "compiler_invocation_flags": attrs.list(attrs.string(), default = []),
            "configs": attrs.dict(key = attrs.string(), value = attrs.dict(key = attrs.string(), value = attrs.string(), sorted = False), sorted = False, default = {}),
            "contacts": attrs.list(attrs.string(), default = []),
            "cxx_runtime_type": attrs.option(attrs.enum(CxxRuntimeType), default = None),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "default_platform": attrs.option(attrs.string(), default = None),
            "defaults": attrs.dict(key = attrs.string(), value = attrs.string(), sorted = False, default = {}),
            "deps_query": attrs.option(attrs.query(), default = None),
            "devirt_enabled": attrs.bool(default = False),
            "executable_name": attrs.option(attrs.string(), default = None),
            "fat_lto": attrs.bool(default = False),
            "focused_list_target": attrs.option(attrs.dep(), default = None),
            "frameworks": attrs.list(attrs.string(), default = []),
            "function_name": attrs.option(attrs.string(), default = None),
            "header_namespace": attrs.option(attrs.string(), default = None),
            "headers": attrs.named_set(attrs.source(), sorted = True, default = []),
            "headers_as_raw_headers_mode": attrs.option(attrs.enum(HeadersAsRawHeadersMode), default = None),
            "include_directories": attrs.set(attrs.string(), sorted = True, default = []),
            "labels": attrs.list(attrs.string(), default = []),
            "lang_compiler_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.arg()), sorted = False, default = {}),
            "lang_platform_compiler_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg()))), sorted = False, default = {}),
            "lang_platform_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg()))), sorted = False, default = {}),
            "lang_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.arg()), sorted = False, default = {}),
            "libraries": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "link_deps_query_whole": attrs.bool(default = False),
            "link_group": attrs.option(attrs.string(), default = None),
            "link_group_map": attrs.option(attrs.list(attrs.tuple(attrs.string(), attrs.list(attrs.tuple(attrs.dep(), attrs.enum(Traversal), attrs.option(attrs.string()))))), default = None),
            "link_style": attrs.option(attrs.enum(LinkableDepType), default = None),
            "linker_extra_outputs": attrs.list(attrs.string(), default = []),
            "platform_deps": attrs.list(attrs.tuple(attrs.regex(), attrs.set(attrs.dep(), sorted = True)), default = []),
            "platform_headers": attrs.list(attrs.tuple(attrs.regex(), attrs.named_set(attrs.source(), sorted = True)), default = []),
            "platform_preprocessor_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
            "platform_srcs": attrs.list(attrs.tuple(attrs.regex(), attrs.set(attrs.one_of(attrs.source(), attrs.tuple(attrs.source(), attrs.list(attrs.arg()))), sorted = True)), default = []),
            "post_linker_flags": attrs.list(attrs.arg(), default = []),
            "post_platform_linker_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
            "precompiled_header": attrs.option(attrs.source(), default = None),
            "prefer_stripped_objects": attrs.bool(default = False),
            "prefix_header": attrs.option(attrs.source(), default = None),
            "preprocessor_flags": attrs.list(attrs.arg(), default = []),
            "raw_headers": attrs.set(attrs.source(), sorted = True, default = []),
            "thin_lto": attrs.bool(default = False),
            "version_universe": attrs.option(attrs.string(), default = None),
            "weak_framework_names": attrs.list(attrs.string(), default = []),
        }
    ),
)

halide_rules = struct(
    halide_library = halide_library,
)
