# Copyright (c) Meta Platforms, Inc. and affiliates.
#
# This source code is licensed under both the MIT license found in the
# LICENSE-MIT file in the root directory of this source tree and the Apache
# License, Version 2.0 found in the LICENSE-APACHE file in the root directory
# of this source tree.

# TODO(cjhopman): This was generated by scripts/hacks/rules_shim_with_docs.py,
# but should be manually edited going forward. There may be some errors in
# the generated docs, and so those should be verified to be accurate and
# well-formatted (and then delete this TODO)

load(":apple_common.bzl", "apple_common")
load(":common.bzl", "CxxRuntimeType", "CxxSourceType", "HeadersAsRawHeadersMode", "IncludeType", "Linkage", "Traversal", "buck", "prelude_rule")
load(":cxx_common.bzl", "cxx_common")
load(":native_common.bzl", "native_common")

AdditionalActions = ["pre_scheme_actions", "post_scheme_actions"]

AppleBundleExtension = ["app", "framework", "appex", "plugin", "bundle", "xctest", "dsym", "xpc", "prefpane", "qlgenerator"]

AppleResourceBundleDestination = ["resources", "frameworks", "executables", "plugins", "xpcservices", "loginitems", "systemextensions"]

LaunchStyle = ["auto", "wait"]

SchemeActionType = ["build", "launch", "test", "profile", "analyze", "archive"]

WatchInterface = ["main", "complication", "dynamic_notification", "static_notification"]

apple_asset_catalog = prelude_rule(
    name = "apple_asset_catalog",
    docs = """
        An `apple_asset_catalog()` rule contains resources stored in Apple asset catalog
        directories. This rule does not have any output on its own and can be built only as a dependency
        (either direct or transitive) of an `apple_bundle()` rule, in which case all `apple_asset_catalog()` rules
        that the bundle rule depends on are merged and placed into the final output bundle together.
    """,
    examples = """
        ```

        apple_asset_catalog(
          name = 'MyAssetCatalog',
          dirs = [
            'MyResources.xcassets',
          ],
        )

        # A asset catalog with a app icon and launch image
        apple_asset_catalog(
          name = 'AssetCatalog',
          dirs = [ 'AssetCatalog.xcassets' ],
          app_icon = 'Icon',
          launch_image = 'LaunchImage',
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "dirs": attrs.list(attrs.source(), default = [], doc = """
                Set of paths of Apple asset catalogs contained by this rule. All paths have to end with the `.xcassets` extension and be compatible with the asset catalog format used by Xcode.
            """),
            "app_icon": attrs.option(attrs.string(), default = None, doc = """
                An optional reference to a `.appiconset` containing a image set representing an
                 application icon. (The extension itself should not be included.) This parameter
                 may be specified at most once in a given `apple_bundle`'s transitive dependencies.
            """),
            "launch_image": attrs.option(attrs.string(), default = None, doc = """
                An optional reference to a `.launchimage` containing a image set representing an
                 application launch image. (The extension itself should not be included.) This parameter
                 may be specified at most once in a given `apple_bundle`'s transitive dependencies.
            """),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
        }
    ),
)

apple_binary = prelude_rule(
    name = "apple_binary",
    docs = """
        An `apple_binary()` rule builds a native executable\342\200\224such as an iOS or OSX app\342\200\224from
        the supplied set of Objective-C/C++ source files and dependencies. It is similar to
        a `cxx\\_binary()`rule with which it shares many attributes. In addition
        to those common attributes, `apple_binary()` has a some additional attributes
        that are specific to binaries intended to be built using the Apple toolchain.
        Note, however, that `apple_binary()` and `cxx_binary()` differ
        in the way that they import header files, in order to better accommodate existing conventions.
        See the sections for the `headers` and `exported_headers` attributes for more details.


        Buck enables you to override components of the Apple toolchain with
        alternate tools, either from the Xcode search paths or from directories
        that you specify.
        See `.buckconfig`
        and `.buckconfig`
        for more information.
    """,
    examples = """
        ```

        apple_binary(
          name = 'MyBinary',
          deps = [
            ':MyLibrary',
            '//Libraries:AnotherLibrary',
          ],
          preprocessor_flags = ['-fobjc-arc'],
          headers = [
            'MyHeader.h',
          ],
          srcs = [
            'MySource.m',
          ],
          frameworks = [
            '$SDKROOT/System/Library/Frameworks/UIKit.framework',
            '$SDKROOT/System/Library/Frameworks/Foundation.framework',
          ],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        cxx_common.srcs_arg() |
        cxx_common.platform_srcs_arg() |
        apple_common.headers_arg() |
        {
            "entitlements_file": attrs.option(attrs.source(), default = None, doc = """
                An optional name of a plist file to be embedded in the binary. Some platforms like
                 `iphonesimulator` require this to run properly.
            """),
        } |
        apple_common.exported_headers_arg() |
        apple_common.header_path_prefix_arg() |
        apple_common.frameworks_arg() |
        cxx_common.preprocessor_flags_arg() |
        cxx_common.exported_preprocessor_flags_arg(exported_preprocessor_flags_type = attrs.list(attrs.arg(), default = [])) |
        cxx_common.compiler_flags_arg() |
        cxx_common.platform_compiler_flags_arg() |
        cxx_common.linker_extra_outputs_arg() |
        cxx_common.linker_flags_arg() |
        cxx_common.exported_linker_flags_arg() |
        cxx_common.platform_linker_flags_arg() |
        native_common.link_style() |
        apple_common.target_sdk_version() |
        apple_common.extra_xcode_sources() |
        apple_common.extra_xcode_files() |
        {
            "bridging_header": attrs.option(attrs.source(), default = None),
            "can_be_asset": attrs.option(attrs.bool(), default = None),
            "configs": attrs.dict(key = attrs.string(), value = attrs.dict(key = attrs.string(), value = attrs.string(), sorted = False), sorted = False, default = {}),
            "contacts": attrs.list(attrs.string(), default = []),
            "cxx_runtime_type": attrs.option(attrs.enum(CxxRuntimeType), default = None),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "default_platform": attrs.option(attrs.string(), default = None),
            "defaults": attrs.dict(key = attrs.string(), value = attrs.string(), sorted = False, default = {}),
            "deps": attrs.list(attrs.dep(), default = []),
            "devirt_enabled": attrs.bool(default = False),
            "diagnostics": attrs.dict(key = attrs.string(), value = attrs.source(), sorted = False, default = {}),
            "enable_cxx_interop": attrs.bool(default = False),
            "executable_name": attrs.option(attrs.string(), default = None),
            "exported_deps": attrs.list(attrs.dep(), default = []),
            "exported_header_style": attrs.enum(IncludeType, default = "local"),
            "exported_lang_platform_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg()))), sorted = False, default = {}),
            "exported_lang_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.arg()), sorted = False, default = {}),
            "exported_platform_deps": attrs.list(attrs.tuple(attrs.regex(), attrs.set(attrs.dep(), sorted = True)), default = []),
            "exported_platform_headers": attrs.list(attrs.tuple(attrs.regex(), attrs.named_set(attrs.source(), sorted = True)), default = []),
            "exported_platform_linker_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
            "exported_platform_preprocessor_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
            "exported_post_linker_flags": attrs.list(attrs.arg(), default = []),
            "exported_post_platform_linker_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
            "fat_lto": attrs.bool(default = False),
            "focused_list_target": attrs.option(attrs.dep(), default = None),
            "force_static": attrs.option(attrs.bool(), default = None),
            "header_namespace": attrs.option(attrs.string(), default = None),
            "headers_as_raw_headers_mode": attrs.option(attrs.enum(HeadersAsRawHeadersMode), default = None),
            "include_directories": attrs.set(attrs.string(), sorted = True, default = []),
            "info_plist": attrs.option(attrs.source(), default = None),
            "info_plist_substitutions": attrs.dict(key = attrs.string(), value = attrs.string(), sorted = False, default = {}),
            "labels": attrs.list(attrs.string(), default = []),
            "lang_compiler_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.arg()), sorted = False, default = {}),
            "lang_platform_compiler_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg()))), sorted = False, default = {}),
            "lang_platform_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg()))), sorted = False, default = {}),
            "lang_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.arg()), sorted = False, default = {}),
            "libraries": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "link_group": attrs.option(attrs.string(), default = None),
            "link_group_map": attrs.option(attrs.list(attrs.tuple(attrs.string(), attrs.list(attrs.tuple(attrs.dep(), attrs.enum(Traversal), attrs.option(attrs.string()))))), default = None),
            "link_whole": attrs.option(attrs.bool(), default = None),
            "modular": attrs.bool(default = False),
            "module_name": attrs.option(attrs.string(), default = None),
            "module_requires_cxx": attrs.bool(default = False),
            "platform_deps": attrs.list(attrs.tuple(attrs.regex(), attrs.set(attrs.dep(), sorted = True)), default = []),
            "platform_headers": attrs.list(attrs.tuple(attrs.regex(), attrs.named_set(attrs.source(), sorted = True)), default = []),
            "platform_preprocessor_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
            "post_linker_flags": attrs.list(attrs.arg(), default = []),
            "post_platform_linker_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
            "precompiled_header": attrs.option(attrs.source(), default = None),
            "preferred_linkage": attrs.option(attrs.enum(Linkage), default = None),
            "prefix_header": attrs.option(attrs.source(), default = None),
            "public_include_directories": attrs.set(attrs.string(), sorted = True, default = []),
            "public_system_include_directories": attrs.set(attrs.string(), sorted = True, default = []),
            "raw_headers": attrs.set(attrs.source(), sorted = True, default = []),
            "reexport_all_header_dependencies": attrs.option(attrs.bool(), default = None),
            "sdk_modules": attrs.list(attrs.string(), default = []),
            "serialize_debugging_options": attrs.bool(default = False),
            "soname": attrs.option(attrs.string(), default = None),
            "static_library_basename": attrs.option(attrs.string(), default = None),
            "supported_platforms_regex": attrs.option(attrs.regex(), default = None),
            "supports_merged_linking": attrs.option(attrs.bool(), default = None),
            "swift_compiler_flags": attrs.list(attrs.arg(), default = []),
            "swift_version": attrs.option(attrs.string(), default = None),
            "thin_lto": attrs.bool(default = False),
            "use_submodules": attrs.bool(default = False),
            "uses_cxx_explicit_modules": attrs.bool(default = False),
            "uses_explicit_modules": attrs.bool(default = False),
            "uses_modules": attrs.bool(default = False),
            "xcode_private_headers_symlinks": attrs.option(attrs.bool(), default = None),
            "xcode_public_headers_symlinks": attrs.option(attrs.bool(), default = None),
        }
    ),
)

apple_bundle = prelude_rule(
    name = "apple_bundle",
    docs = """
        An `apple_bundle()` rule takes an Apple binary and all of the resources and asset
        catalogs in the rule's transitive dependencies and generates a bundle containing all of those files.
        Optionally the generated bundle can also be signed using specified provisioning profiles.


        Code signing will embed entitlements pointed to by the `entitlements_file` arg in
        the bundle's `apple_binary`. This is the preferred way to specify entitlements
        when building with Buck.

        If the entitlements file is not present, it falls back to the `CODE_SIGN_ENTITLEMENTS` entry in
         `info_plist_substitutions`.


        If after these checks, an entitlements file is still not specified, it will be derived based
        on the entitlements of the selected provisioning profile. Provisioning profiles will be selected
        from profiles pointed to by `apple.provisioning_profile_search_path`, based on a
        non-expired profile that matches the bundle id and entitlements.


        Code signing will embed entitlements pointed to by the `CODE_SIGN_ENTITLEMENTS` entry in
        `info_plist_substitutions`. If an entitlements file is omitted, it will be derived based
        on the entitlements of the selected provisioning profile. Provisioning profiles will be selected
        from profiles pointed to by `apple.provisioning_profile_search_path`, based on a
        non-expired profile that matches the bundle id and entitlements.
    """,
    examples = """
        ```

        apple_bundle(
          name = 'AppBundle',
          binary = ':MyBinary',
          extension = 'app',
          info_plist = 'Info.plist',
        )

        ```

        ```

        # iOS app with embedded WatchOS 2.0 app/extension
        apple_bundle(
          name = 'DemoWatchAppExtension',
          binary = ':DemoWatchAppExtensionBinary',
          extension = 'appex',
          info_plist = 'WatchExtension/Resources/Info.plist',
        )

        apple_bundle(
          name = 'DemoWatchApp',
          binary = ':DemoWatchAppBinary',
          deps = [':DemoWatchAppResources', ':DemoWatchAppExtension'],
          extension = 'app',
          info_plist = 'WatchApplication/Info.plist',
        )

        apple_bundle(
          name = 'DemoApp',
          binary = ':DemoAppBinary',
          deps = [':DemoWatchApp#watch'],
          extension = 'app',
          info_plist = 'Info.plist',
        )

        ```

        ```

        # iOS app using safeAreaInsets delivering to iOS 9.x
        apple_bundle(
          name = 'DemoIBApp',
          binary = ':DemoIBAppBinary',
          deps = [':DemoIBAppResources'],
          extension = 'app',
          ibtool_flags = ["--minimum-deployment-target", "9.0"],
          info_plist = 'Info.plist',
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "deps": attrs.list(attrs.dep(), default = [], doc = """
                A list of dependencies of this bundle as build targets. You can embed application
                 extensions by specifying the extension's bundle target. To include a WatchKit app, append the
                 flavor `#watch` to the target specification. Buck will automatically substitute the appropriate
                 platform flavor (either `watchsimulator` or `watchos`) based on the parent.
            """),
            "product_name": attrs.option(attrs.string(), default = None, doc = """
                The name of the resulting bundle and binary. The setting behaves like PRODUCT\\_NAME Xcode build setting.
                 For example, if your rule is named "MyApp" and extension is "app", by default buck will generate MyApp.app bundle.
                 But if you will set product name to "SuperApp", bundle will get "SuperApp.app" name.
            """),
            "extension": attrs.one_of(attrs.enum(AppleBundleExtension), attrs.string(), doc = """
                The extension of the generated bundle. For example `'app'` for an application bundle
                 or `'appex'` for an application extension bundle.
            """),
            "binary": attrs.option(attrs.dep(), default = None, doc = """
                A `build target` identifying
                 an `apple_binary()` rule or
                 an `apple_library()` rule whose output will
                 be used as the main executable binary of the generated bundle. The required rule type depends
                 on the value in the `extension` attribute. For example, application bundles expect
                 a binary (e.g. `'//Apps/MyApp:MyApp'`), application extension bundles expect a shared
                 library (e.g. `'//Libraries/MyLibrary:MyLibrary#shared'`).
            """),
        } |
        apple_common.info_plist_arg() |
        apple_common.info_plist_substitutions_arg() |
        {
            "asset_catalogs_compilation_options": attrs.dict(key = attrs.string(), value = attrs.any(), default = {}, doc = """
                A dict holding parameters for asset catalogs compiler (actool). Its options include:
                 * `notices` (defaults to `True`)
                * `warnings` (defaults to `True`)
                * `errors` (defaults to `True`)
                * `compress_pngs` (defaults to `True`)
                * `optimization` (defaults to `'space'`)
                * `output_format` (defaults to `'human-readable-text'`)
                * `extra_flags` (defaults to `[]`)
            """),
            "ibtool_flags": attrs.option(attrs.list(attrs.string()), default = None, doc = """
                List of flags to be passed to ibtool during interface builder file compilation.
            """),
            "codesign_flags": attrs.list(attrs.string(), default = []),
            "codesign_identity": attrs.option(attrs.string(), default = None),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "default_platform": attrs.option(attrs.string(), default = None),
            "ibtool_module_flag": attrs.option(attrs.bool(), default = None),
            "incremental_bundling_enabled": attrs.option(attrs.bool(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "platform_binary": attrs.option(attrs.list(attrs.tuple(attrs.regex(), attrs.dep())), default = None),
            "resource_group": attrs.option(attrs.string(), default = None),
            "resource_group_map": attrs.option(attrs.list(attrs.tuple(attrs.string(), attrs.list(attrs.tuple(attrs.dep(), attrs.enum(Traversal), attrs.option(attrs.string()))))), default = None),
            "skip_copying_swift_stdlib": attrs.option(attrs.bool(), default = None),
            "try_skip_code_signing": attrs.option(attrs.bool(), default = None),
            "xcode_product_type": attrs.option(attrs.string(), default = None),
        }
    ),
)

apple_library = prelude_rule(
    name = "apple_library",
    docs = """
        An `apple_library()` rule represents a set of Objective-C/C++/Swift
        source files and is similar to a `cxx_library()` rule with which it shares many
        attributes. In addition to those common attributes, `apple_library()` has a some additional attributes
        that are specific to binaries intended to be built using the Apple toolchain.
        Note, however, that `apple_library()` and `cxx_library()` differ
        in the way that they import header files, in order to better accommodate existing conventions.
        See the sections for the `headers` and `exported_headers` attributes for more details.


        Buck enables you to override components of the Apple toolchain with
        alternate tools, either from the Xcode search paths or from directories
        that you specify.
        See `.buckconfig`
        and `.buckconfig`
        for more information.
    """,
    examples = """
        ```

        apple_library(
          name = 'MyLibrary',
          deps = [
            ':OtherLibrary',
            '//Libraries:YetAnotherLibrary',
          ],
          preprocessor_flags = ['-fobjc-arc'],
          headers = [
            'MyHeader.h',
          ],
          srcs = [
            'MySource.m',
            'MySource.swift',
          ],
          frameworks = [
            '$SDKROOT/System/Library/Frameworks/UIKit.framework',
            '$SDKROOT/System/Library/Frameworks/Foundation.framework',
          ],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        cxx_common.srcs_arg() |
        cxx_common.platform_srcs_arg() |
        apple_common.headers_arg() |
        apple_common.exported_headers_arg() |
        apple_common.header_path_prefix_arg() |
        cxx_common.header_namespace_arg() |
        apple_common.frameworks_arg() |
        cxx_common.preprocessor_flags_arg() |
        cxx_common.exported_preprocessor_flags_arg(exported_preprocessor_flags_type = attrs.list(attrs.arg(), default = [])) |
        cxx_common.compiler_flags_arg() |
        cxx_common.platform_compiler_flags_arg() |
        cxx_common.linker_extra_outputs_arg() |
        cxx_common.linker_flags_arg() |
        cxx_common.exported_linker_flags_arg() |
        cxx_common.exported_platform_linker_flags_arg() |
        apple_common.target_sdk_version() |
        native_common.preferred_linkage(preferred_linkage_type = attrs.option(attrs.enum(Linkage), default = None)) |
        native_common.link_style() |
        native_common.link_whole(link_whole_type = attrs.option(attrs.bool(), default = None)) |
        cxx_common.reexport_all_header_dependencies_arg() |
        cxx_common.exported_deps_arg() |
        apple_common.extra_xcode_sources() |
        apple_common.extra_xcode_files() |
        {
            "bridging_header": attrs.option(attrs.source(), default = None),
            "can_be_asset": attrs.option(attrs.bool(), default = None),
            "configs": attrs.dict(key = attrs.string(), value = attrs.dict(key = attrs.string(), value = attrs.string(), sorted = False), sorted = False, default = {}),
            "contacts": attrs.list(attrs.string(), default = []),
            "cxx_runtime_type": attrs.option(attrs.enum(CxxRuntimeType), default = None),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "default_platform": attrs.option(attrs.string(), default = None),
            "defaults": attrs.dict(key = attrs.string(), value = attrs.string(), sorted = False, default = {}),
            "deps": attrs.list(attrs.dep(), default = []),
            "devirt_enabled": attrs.bool(default = False),
            "diagnostics": attrs.dict(key = attrs.string(), value = attrs.source(), sorted = False, default = {}),
            "enable_cxx_interop": attrs.bool(default = False),
            "executable_name": attrs.option(attrs.string(), default = None),
            "exported_header_style": attrs.enum(IncludeType, default = "local"),
            "exported_lang_platform_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg()))), sorted = False, default = {}),
            "exported_lang_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.arg()), sorted = False, default = {}),
            "exported_platform_deps": attrs.list(attrs.tuple(attrs.regex(), attrs.set(attrs.dep(), sorted = True)), default = []),
            "exported_platform_headers": attrs.list(attrs.tuple(attrs.regex(), attrs.named_set(attrs.source(), sorted = True)), default = []),
            "exported_platform_preprocessor_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
            "exported_post_linker_flags": attrs.list(attrs.arg(), default = []),
            "exported_post_platform_linker_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
            "fat_lto": attrs.bool(default = False),
            "focused_list_target": attrs.option(attrs.dep(), default = None),
            "force_static": attrs.option(attrs.bool(), default = None),
            "headers_as_raw_headers_mode": attrs.option(attrs.enum(HeadersAsRawHeadersMode), default = None),
            "include_directories": attrs.set(attrs.string(), sorted = True, default = []),
            "info_plist": attrs.option(attrs.source(), default = None),
            "info_plist_substitutions": attrs.dict(key = attrs.string(), value = attrs.string(), sorted = False, default = {}),
            "labels": attrs.list(attrs.string(), default = []),
            "lang_compiler_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.arg()), sorted = False, default = {}),
            "lang_platform_compiler_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg()))), sorted = False, default = {}),
            "lang_platform_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg()))), sorted = False, default = {}),
            "lang_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.arg()), sorted = False, default = {}),
            "libraries": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "link_group": attrs.option(attrs.string(), default = None),
            "link_group_map": attrs.option(attrs.list(attrs.tuple(attrs.string(), attrs.list(attrs.tuple(attrs.dep(), attrs.enum(Traversal), attrs.option(attrs.string()))))), default = None),
            "modular": attrs.bool(default = False),
            "module_name": attrs.option(attrs.string(), default = None),
            "module_requires_cxx": attrs.bool(default = False),
            "platform_deps": attrs.list(attrs.tuple(attrs.regex(), attrs.set(attrs.dep(), sorted = True)), default = []),
            "platform_headers": attrs.list(attrs.tuple(attrs.regex(), attrs.named_set(attrs.source(), sorted = True)), default = []),
            "platform_linker_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
            "platform_preprocessor_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
            "post_linker_flags": attrs.list(attrs.arg(), default = []),
            "post_platform_linker_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
            "precompiled_header": attrs.option(attrs.source(), default = None),
            "prefix_header": attrs.option(attrs.source(), default = None),
            "public_include_directories": attrs.set(attrs.string(), sorted = True, default = []),
            "public_system_include_directories": attrs.set(attrs.string(), sorted = True, default = []),
            "raw_headers": attrs.set(attrs.source(), sorted = True, default = []),
            "sdk_modules": attrs.list(attrs.string(), default = []),
            "serialize_debugging_options": attrs.bool(default = False),
            "soname": attrs.option(attrs.string(), default = None),
            "static_library_basename": attrs.option(attrs.string(), default = None),
            "supported_platforms_regex": attrs.option(attrs.regex(), default = None),
            "supports_merged_linking": attrs.option(attrs.bool(), default = None),
            "swift_compiler_flags": attrs.list(attrs.arg(), default = []),
            "swift_version": attrs.option(attrs.string(), default = None),
            "thin_lto": attrs.bool(default = False),
            "use_submodules": attrs.bool(default = False),
            "uses_cxx_explicit_modules": attrs.bool(default = False),
            "uses_explicit_modules": attrs.bool(default = False),
            "uses_modules": attrs.bool(default = False),
            "xcode_private_headers_symlinks": attrs.option(attrs.bool(), default = None),
            "xcode_public_headers_symlinks": attrs.option(attrs.bool(), default = None),
        }
    ),
)

apple_package = prelude_rule(
    name = "apple_package",
    docs = """
        An `apple_package()` rule takes the output of
        an `apple_bundle()` rule and compresses it in
        an IPA (iOS App Store Package) file.

        This rule can be customized using the config options `.buckconfig`
        and `.buckconfig`
        .
    """,
    examples = """
        ```

        apple_package(
          name = 'AppPackage',
          bundle = ':AppBundle',
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "bundle": attrs.dep(doc = """
                A build target identifying
                 an `apple_bundle()` rule whose output will
                 be stored in the IPA package generated by this rule.
            """),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "default_platform": attrs.option(attrs.string(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "need_android_tools": attrs.bool(default = False),
        }
    ),
)

apple_resource = prelude_rule(
    name = "apple_resource",
    docs = """
        An `apple_resource()` rule contains sets of resource directories, files and file variants
        that can be bundled in an application bundle. This rule does not have any output on its own and can
        be built only as a dependency (either direct or transitive) of
        an `apple_bundle()` rule.
    """,
    examples = """
        ```

        apple_resource(
          name = 'Images',
          files = glob([
            '*.png',
          ]),
          dirs = [
            'PrettyImages',
          ],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "dirs": attrs.list(attrs.source(), default = [], doc = """
                Set of paths of resource directories that should be placed in an application bundle.
            """),
            "content_dirs": attrs.list(attrs.source(), default = [], doc = """
                Set of paths of directories containing resource files that should be placed in an application bundle. Unlike `dirs`, the directories themselves are not placed in the bundle.
            """),
            "files": attrs.list(attrs.source(), default = [], doc = """
                Set of paths of resource files that should be placed in an application bundle.
            """),
            "variants": attrs.list(attrs.source(), default = [], doc = """
                Set of paths of resource file variants that should be placed in an application bundle. The files
                 mentioned here should be placed in a directory named `$VARIANT_NAME.lproj`,
                 where `$VARIANT_NAME` is the name of the variant
                 (e.g. `Base`, `en`). This argument makes it possible to use different
                 resource files based on the active locale.
            """),
            "named_variants": attrs.dict(key = attrs.string(), value = attrs.set(attrs.source(), sorted = False), sorted = False, default = {}, doc = """
                Mapping from a variant name to the list of resource file paths which should be placed in an application bundle. Those files
                 will be placed in a directory with name equal to the corresponding key in this mapping. Keys should end with `.lproj` suffix.
                 (e.g. `Base.lproj`, `en.lproj`).
            """),
            "resources_from_deps": attrs.list(attrs.dep(), default = [], doc = """
                Set of build targets whose transitive `apple_resource`s should be considered as part of
                 the current resource when collecting resources for bundles.

                 Usually, an `apple_bundle` collects all `apple_resource` rules transitively
                 reachable through apple\\_library rules. This field allows for resources which are not reachable
                 using the above traversal strategy to be considered for inclusion in the bundle.
            """),
            "destination": attrs.option(attrs.enum(AppleResourceBundleDestination), default = None, doc = """
                Specifies the destination in the final application bundle where resource will be copied. Possible
                 values: "resources", "frameworks", "executables", "plugins", "xpcservices".
            """),
            "codesign_on_copy": attrs.bool(default = False, doc = """
                Indicates whether the files specified in the files arg in this resource should be code signed with the identity used to sign the overall bundle. This is useful for e.g.
                 dylibs or other additional binaries copied into the bundle. The caller is responsible to ensure that the file format is valid for codesigning.
            """),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
        }
    ),
)

apple_test = prelude_rule(
    name = "apple_test",
    docs = """
        An `apple_test()` rule contains Objective-C/C++ code which can be built and used to test
        code contained in other rules. The tests can be executed by running `buck test`.
    """,
    examples = """
        ```

        apple_test(
          name = 'MyTest',
          info_plist = 'MyTest-Info.plist',
          preprocessor_flags = ['-fobjc-arc'],
          srcs = [
            'MyTest.m',
          ],
          deps = [
            ':MyLibrary',
          ],
          frameworks = [
            '$SDKROOT/System/Library/Frameworks/Foundation.framework',
            '$SDKROOT/System/Library/Frameworks/UIKit.framework',
            '$PLATFORM_DIR/Developer/Library/Frameworks/XCTest.framework',
          ],
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        apple_common.info_plist_arg() |
        apple_common.info_plist_substitutions_arg() |
        {
            "test_host_app": attrs.option(attrs.dep(), default = None, doc = """
                A build target identifying
                 an `apple_bundle()` rule that builds an
                 application bundle. Output of the specified rule will be used as a test host of this test. This
                 implies `run_test_separately`.
                 Since symbols that are defined in the test host application and its dependencies will not be
                 linked into the test binary, to make those symbols accessible to the test target they need
                 to be specified as a dependency of this target and `['-undefined', 'dynamic_lookup']`  needs to be added to this target's `linker_flags` (this will suppress undefined
                 reference errors during compilation, but if the symbols do not exist, it might result in runtime
                 crashes).
            """),
        } |
        cxx_common.srcs_arg() |
        cxx_common.platform_srcs_arg() |
        apple_common.headers_arg() |
        apple_common.header_path_prefix_arg() |
        apple_common.frameworks_arg() |
        cxx_common.preprocessor_flags_arg() |
        cxx_common.compiler_flags_arg() |
        cxx_common.platform_compiler_flags_arg() |
        cxx_common.linker_flags_arg() |
        native_common.link_style() |
        apple_common.target_sdk_version() |
        buck.run_test_separately_arg(run_test_separately_type = attrs.bool(default = False)) |
        buck.test_label_arg() |
        apple_common.extra_xcode_sources() |
        apple_common.extra_xcode_files() |
        {
            "asset_catalogs_compilation_options": attrs.dict(key = attrs.string(), value = attrs.any(), default = {}),
            "bridging_header": attrs.option(attrs.source(), default = None),
            "can_be_asset": attrs.option(attrs.bool(), default = None),
            "codesign_flags": attrs.list(attrs.string(), default = []),
            "codesign_identity": attrs.option(attrs.string(), default = None),
            "configs": attrs.dict(key = attrs.string(), value = attrs.dict(key = attrs.string(), value = attrs.string(), sorted = False), sorted = False, default = {}),
            "contacts": attrs.list(attrs.string(), default = []),
            "cxx_runtime_type": attrs.option(attrs.enum(CxxRuntimeType), default = None),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "default_platform": attrs.option(attrs.string(), default = None),
            "defaults": attrs.dict(key = attrs.string(), value = attrs.string(), sorted = False, default = {}),
            "deps": attrs.list(attrs.dep(), default = []),
            "destination_specifier": attrs.dict(key = attrs.string(), value = attrs.string(), sorted = False, default = {}),
            "devirt_enabled": attrs.bool(default = False),
            "diagnostics": attrs.dict(key = attrs.string(), value = attrs.source(), sorted = False, default = {}),
            "enable_cxx_interop": attrs.bool(default = False),
            "entitlements_file": attrs.option(attrs.source(), default = None),
            "env": attrs.option(attrs.dict(key = attrs.string(), value = attrs.arg(), sorted = False), default = None),
            "executable_name": attrs.option(attrs.string(), default = None),
            "exported_deps": attrs.list(attrs.dep(), default = []),
            "exported_header_style": attrs.enum(IncludeType, default = "local"),
            "exported_headers": attrs.named_set(attrs.source(), sorted = True, default = []),
            "exported_lang_platform_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg()))), sorted = False, default = {}),
            "exported_lang_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.arg()), sorted = False, default = {}),
            "exported_linker_flags": attrs.list(attrs.arg(), default = []),
            "exported_platform_deps": attrs.list(attrs.tuple(attrs.regex(), attrs.set(attrs.dep(), sorted = True)), default = []),
            "exported_platform_headers": attrs.list(attrs.tuple(attrs.regex(), attrs.named_set(attrs.source(), sorted = True)), default = []),
            "exported_platform_linker_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
            "exported_platform_preprocessor_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
            "exported_post_linker_flags": attrs.list(attrs.arg(), default = []),
            "exported_post_platform_linker_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
            "exported_preprocessor_flags": attrs.list(attrs.arg(), default = []),
            "fat_lto": attrs.bool(default = False),
            "focused_list_target": attrs.option(attrs.dep(), default = None),
            "force_static": attrs.option(attrs.bool(), default = None),
            "header_namespace": attrs.option(attrs.string(), default = None),
            "headers_as_raw_headers_mode": attrs.option(attrs.enum(HeadersAsRawHeadersMode), default = None),
            "include_directories": attrs.set(attrs.string(), sorted = True, default = []),
            "incremental_bundling_enabled": attrs.option(attrs.bool(), default = None),
            "is_ui_test": attrs.bool(default = False),
            "lang_compiler_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.arg()), sorted = False, default = {}),
            "lang_platform_compiler_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg()))), sorted = False, default = {}),
            "lang_platform_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg()))), sorted = False, default = {}),
            "lang_preprocessor_flags": attrs.dict(key = attrs.enum(CxxSourceType), value = attrs.list(attrs.arg()), sorted = False, default = {}),
            "libraries": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "link_group": attrs.option(attrs.string(), default = None),
            "link_group_map": attrs.option(attrs.list(attrs.tuple(attrs.string(), attrs.list(attrs.tuple(attrs.dep(), attrs.enum(Traversal), attrs.option(attrs.string()))))), default = None),
            "link_whole": attrs.option(attrs.bool(), default = None),
            "linker_extra_outputs": attrs.list(attrs.string(), default = []),
            "modular": attrs.bool(default = False),
            "module_name": attrs.option(attrs.string(), default = None),
            "module_requires_cxx": attrs.bool(default = False),
            "platform_deps": attrs.list(attrs.tuple(attrs.regex(), attrs.set(attrs.dep(), sorted = True)), default = []),
            "platform_headers": attrs.list(attrs.tuple(attrs.regex(), attrs.named_set(attrs.source(), sorted = True)), default = []),
            "platform_linker_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
            "platform_preprocessor_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
            "post_linker_flags": attrs.list(attrs.arg(), default = []),
            "post_platform_linker_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.arg())), default = []),
            "precompiled_header": attrs.option(attrs.source(), default = None),
            "preferred_linkage": attrs.option(attrs.enum(Linkage), default = None),
            "prefix_header": attrs.option(attrs.source(), default = None),
            "public_include_directories": attrs.set(attrs.string(), sorted = True, default = []),
            "public_system_include_directories": attrs.set(attrs.string(), sorted = True, default = []),
            "raw_headers": attrs.set(attrs.source(), sorted = True, default = []),
            "reexport_all_header_dependencies": attrs.option(attrs.bool(), default = None),
            "runner": attrs.option(attrs.dep(), default = None),
            "sdk_modules": attrs.list(attrs.string(), default = []),
            "serialize_debugging_options": attrs.bool(default = False),
            "skip_copying_swift_stdlib": attrs.option(attrs.bool(), default = None),
            "snapshot_reference_images_path": attrs.option(attrs.one_of(attrs.source(), attrs.string()), default = None),
            "soname": attrs.option(attrs.string(), default = None),
            "specs": attrs.option(attrs.arg(json = True), default = None),
            "static_library_basename": attrs.option(attrs.string(), default = None),
            "supported_platforms_regex": attrs.option(attrs.regex(), default = None),
            "supports_merged_linking": attrs.option(attrs.bool(), default = None),
            "swift_compiler_flags": attrs.list(attrs.arg(), default = []),
            "swift_version": attrs.option(attrs.string(), default = None),
            "test_rule_timeout_ms": attrs.option(attrs.int(), default = None),
            "thin_lto": attrs.bool(default = False),
            "try_skip_code_signing": attrs.option(attrs.bool(), default = None),
            "ui_test_target_app": attrs.option(attrs.dep(), default = None),
            "use_submodules": attrs.bool(default = False),
            "uses_cxx_explicit_modules": attrs.bool(default = False),
            "uses_explicit_modules": attrs.bool(default = False),
            "uses_modules": attrs.bool(default = False),
            "xcode_private_headers_symlinks": attrs.option(attrs.bool(), default = None),
            "xcode_product_type": attrs.option(attrs.string(), default = None),
            "xcode_public_headers_symlinks": attrs.option(attrs.bool(), default = None),
        }
    ),
)

apple_toolchain = prelude_rule(
    name = "apple_toolchain",
    docs = "",
    examples = None,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "actool": attrs.source(),
            "architecture": attrs.string(default = ""),
            "build_version": attrs.option(attrs.string(), default = None),
            "codesign": attrs.source(),
            "codesign_allocate": attrs.source(),
            "contacts": attrs.list(attrs.string(), default = []),
            "copy_scene_kit_assets": attrs.option(attrs.source(), default = None),
            "cxx_toolchain": attrs.dep(),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "developer_path": attrs.option(attrs.source(), default = None),
            "dsymutil": attrs.source(),
            "dwarfdump": attrs.option(attrs.source(), default = None),
            "ibtool": attrs.source(),
            "labels": attrs.list(attrs.string(), default = []),
            "libtool": attrs.source(),
            "licenses": attrs.list(attrs.source(), default = []),
            "lipo": attrs.source(),
            "min_version": attrs.string(default = ""),
            "momc": attrs.source(),
            "platform_path": attrs.source(),
            "sdk_environment": attrs.option(attrs.string(), default = None),
            "sdk_name": attrs.string(default = ""),
            "sdk_path": attrs.source(),
            "swift_toolchain": attrs.option(attrs.dep(), default = None),
            "version": attrs.string(default = ""),
            "watch_kit_stub_binary": attrs.option(attrs.source(), default = None),
            "work_around_dsymutil_lto_stack_overflow_bug": attrs.option(attrs.bool(), default = None),
            "xcode_build_version": attrs.string(default = ""),
            "xcode_version": attrs.string(default = ""),
            "xctest": attrs.source(),
        }
    ),
)

apple_toolchain_set = prelude_rule(
    name = "apple_toolchain_set",
    docs = "",
    examples = None,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "apple_toolchains": attrs.list(attrs.dep(), default = []),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
        }
    ),
)

core_data_model = prelude_rule(
    name = "core_data_model",
    docs = """
        An `core_data_model()` rule contains models for Apple's Core Data framework. This rule does not have any output on its own and can be built only as a dependency
        (either direct or transitive) of an `apple_bundle()` rule in which case all `core_data_model()` rules
        that the bundle rule depends on are merged and placed into the final output bundle together.
    """,
    examples = """
        ```

        core_data_model(
          name = 'MyCoreDataModel',
          path = 'MyCoreDataModel.xcdatamodeld',
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "path": attrs.source(doc = """
                Relative path of the .xcdatamodeld package directory.
            """),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
        }
    ),
)

prebuilt_apple_framework = prelude_rule(
    name = "prebuilt_apple_framework",
    docs = """
        A `prebuilt_apple_framework()` rule represents a set of
         Objective-C/C++ source files and is very similar to a `prebuilt_cxx_library()` rule.
    """,
    examples = """
        ```

        prebuilt_apple_framework(
          name = 'MyPrebuiltFramework',
          framework = 'myPrebuiltFramework.framework',
          preferred_linkage = 'static',
          visibility = [
            'PUBLIC'
          ]
        )

        ```
    """,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "preferred_linkage": attrs.enum(Linkage, doc = """
                How to link to a binary: use `dynamic` for a dynamic
                 framework, and `static` for old universal static
                 frameworks manually lipo-ed together. `dynamic` will
                 copy the frameworks into the `Frameworks` directory
                 of an Apple bundle, and configure framework search paths and linker flags.
                 `static` will copy the resources of the framework into
                 an Apple bundle.
            """),
            "code_sign_on_copy": attrs.option(attrs.bool(), default = None),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "deps": attrs.list(attrs.dep(), default = []),
            "exported_linker_flags": attrs.list(attrs.string(), default = []),
            "exported_platform_linker_flags": attrs.list(attrs.tuple(attrs.regex(), attrs.list(attrs.string())), default = []),
            "framework": attrs.source(),
            "frameworks": attrs.list(attrs.string(), default = []),
            "labels": attrs.list(attrs.string(), default = []),
            "libraries": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "supported_platforms_regex": attrs.option(attrs.regex(), default = None),
        }
    ),
)

scene_kit_assets = prelude_rule(
    name = "scene_kit_assets",
    docs = "",
    examples = None,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "path": attrs.source(),
        }
    ),
)

swift_library = prelude_rule(
    name = "swift_library",
    docs = "",
    examples = None,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "bridging_header": attrs.option(attrs.source(), default = None),
            "compiler_flags": attrs.list(attrs.arg(), default = []),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "deps": attrs.list(attrs.dep(), default = []),
            "enable_cxx_interop": attrs.bool(default = False),
            "frameworks": attrs.list(attrs.string(), default = []),
            "labels": attrs.list(attrs.string(), default = []),
            "libraries": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "module_name": attrs.option(attrs.string(), default = None),
            "preferred_linkage": attrs.option(attrs.enum(Linkage), default = None),
            "sdk_modules": attrs.list(attrs.string(), default = []),
            "serialize_debugging_options": attrs.bool(default = False),
            "soname": attrs.option(attrs.string(), default = None),
            "srcs": attrs.list(attrs.source(), default = []),
            "supported_platforms_regex": attrs.option(attrs.regex(), default = None),
            "target_sdk_version": attrs.option(attrs.string(), default = None),
            "uses_explicit_modules": attrs.bool(default = False),
            "version": attrs.option(attrs.string(), default = None),
        }
    ),
)

swift_toolchain = prelude_rule(
    name = "swift_toolchain",
    docs = "",
    examples = None,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "can_toolchain_emit_obj_c_header_textually": attrs.bool(default = False),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "explicit_modules_uses_gmodules": attrs.bool(default = False),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "platform_path": attrs.source(),
            "prefix_serialized_debug_info": attrs.bool(default = False),
            "resource_dir": attrs.option(attrs.source(), default = None),
            "runtime_paths_for_bundling": attrs.list(attrs.string(), default = []),
            "runtime_paths_for_linking": attrs.list(attrs.string(), default = []),
            "runtime_run_paths": attrs.list(attrs.string(), default = []),
            "sdk_dependencies_path": attrs.option(attrs.string(), default = None),
            "sdk_path": attrs.source(),
            "static_runtime_paths": attrs.list(attrs.string(), default = []),
            "supports_swift_cxx_interoperability_mode": attrs.bool(default = False),
            "supports_cxx_interop_requirement_at_import": attrs.bool(default = False),
            "swift_stdlib_tool": attrs.option(attrs.source(), default = None),
            "swift_stdlib_tool_flags": attrs.list(attrs.arg(), default = []),
            "swiftc": attrs.source(),
            "swiftc_flags": attrs.list(attrs.arg(), default = []),
        }
    ),
)

xcode_postbuild_script = prelude_rule(
    name = "xcode_postbuild_script",
    docs = "",
    examples = None,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "cmd": attrs.string(default = ""),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "input_file_lists": attrs.list(attrs.string(), default = []),
            "inputs": attrs.list(attrs.string(), default = []),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "output_file_lists": attrs.list(attrs.string(), default = []),
            "outputs": attrs.list(attrs.string(), default = []),
            "srcs": attrs.list(attrs.source(), default = []),
        }
    ),
)

xcode_prebuild_script = prelude_rule(
    name = "xcode_prebuild_script",
    docs = "",
    examples = None,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "cmd": attrs.string(default = ""),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "input_file_lists": attrs.list(attrs.string(), default = []),
            "inputs": attrs.list(attrs.string(), default = []),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "output_file_lists": attrs.list(attrs.string(), default = []),
            "outputs": attrs.list(attrs.string(), default = []),
            "srcs": attrs.list(attrs.source(), default = []),
        }
    ),
)

xcode_workspace_config = prelude_rule(
    name = "xcode_workspace_config",
    docs = "",
    examples = None,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "action_config_names": attrs.dict(key = attrs.enum(SchemeActionType), value = attrs.string(), sorted = False, default = {}),
            "additional_scheme_actions": attrs.option(attrs.dict(key = attrs.enum(SchemeActionType), value = attrs.dict(key = attrs.enum(AdditionalActions), value = attrs.list(attrs.string()), sorted = False), sorted = False), default = None),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "environment_variables": attrs.option(attrs.dict(key = attrs.enum(SchemeActionType), value = attrs.dict(key = attrs.string(), value = attrs.string(), sorted = False), sorted = False), default = None),
            "explicit_runnable_path": attrs.option(attrs.string(), default = None),
            "extra_schemes": attrs.dict(key = attrs.string(), value = attrs.dep(), sorted = False, default = {}),
            "extra_shallow_targets": attrs.list(attrs.dep(), default = []),
            "extra_targets": attrs.list(attrs.dep(), default = []),
            "extra_tests": attrs.list(attrs.dep(), default = []),
            "is_remote_runnable": attrs.option(attrs.bool(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "launch_style": attrs.option(attrs.enum(LaunchStyle), default = None),
            "licenses": attrs.list(attrs.source(), default = []),
            "notification_payload_file": attrs.option(attrs.string(), default = None),
            "src_target": attrs.option(attrs.dep(), default = None),
            "was_created_for_app_extension": attrs.option(attrs.bool(), default = None),
            "watch_interface": attrs.option(attrs.enum(WatchInterface), default = None),
            "workspace_name": attrs.option(attrs.string(), default = None),
        }
    ),
)

ios_rules = struct(
    apple_asset_catalog = apple_asset_catalog,
    apple_binary = apple_binary,
    apple_bundle = apple_bundle,
    apple_library = apple_library,
    apple_package = apple_package,
    apple_resource = apple_resource,
    apple_test = apple_test,
    apple_toolchain = apple_toolchain,
    apple_toolchain_set = apple_toolchain_set,
    core_data_model = core_data_model,
    prebuilt_apple_framework = prebuilt_apple_framework,
    scene_kit_assets = scene_kit_assets,
    swift_library = swift_library,
    swift_toolchain = swift_toolchain,
    xcode_postbuild_script = xcode_postbuild_script,
    xcode_prebuild_script = xcode_prebuild_script,
    xcode_workspace_config = xcode_workspace_config,
)
