# Copyright (c) Meta Platforms, Inc. and affiliates.
#
# This source code is licensed under both the MIT license found in the
# LICENSE-MIT file in the root directory of this source tree and the Apache
# License, Version 2.0 found in the LICENSE-APACHE file in the root directory
# of this source tree.

# TODO(cjhopman): This was generated by scripts/hacks/rules_shim_with_docs.py,
# but should be manually edited going forward. There may be some errors in
# the generated docs, and so those should be verified to be accurate and
# well-formatted (and then delete this TODO)

load(":common.bzl", "prelude_rule")

js_bundle = prelude_rule(
    name = "js_bundle",
    docs = "",
    examples = None,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "android_package": attrs.option(attrs.string(), default = None),
            "bundle_name": attrs.option(attrs.string(), default = None),
            "bundle_name_for_flavor": attrs.list(attrs.tuple(attrs.string(), attrs.string()), default = []),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "deps": attrs.list(attrs.dep(), default = []),
            "entry": attrs.one_of(attrs.set(attrs.string(), sorted = False), attrs.string()),
            "extra_json": attrs.option(attrs.arg(), default = None),
            "fallback_transform_profile": attrs.option(attrs.string(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "worker": attrs.dep(),
        }
    ),
)

js_bundle_genrule = prelude_rule(
    name = "js_bundle_genrule",
    docs = "",
    examples = None,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "bash": attrs.option(attrs.arg(), default = None),
            "bundle_name": attrs.option(attrs.string(), default = None),
            "bundle_name_for_flavor": attrs.list(attrs.tuple(attrs.string(), attrs.string()), default = []),
            "cacheable": attrs.option(attrs.bool(), default = None),
            "cmd": attrs.option(attrs.arg(), default = None),
            "cmd_exe": attrs.option(attrs.arg(), default = None),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "enable_sandbox": attrs.option(attrs.bool(), default = None),
            "environment_expansion_separator": attrs.option(attrs.string(), default = None),
            "js_bundle": attrs.dep(),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "need_android_tools": attrs.bool(default = False),
            "remote": attrs.option(attrs.bool(), default = None),
            "rewrite_deps_file": attrs.bool(default = False),
            "rewrite_misc": attrs.bool(default = False),
            "rewrite_sourcemap": attrs.bool(default = False),
            "skip_resources": attrs.bool(default = False),
            "srcs": attrs.named_set(attrs.source(), sorted = False, default = []),
        }
    ),
)

js_library = prelude_rule(
    name = "js_library",
    docs = "",
    examples = None,
    further = None,
    attrs = (
        # @unsorted-dict-items
        {
            "asset_extensions": attrs.option(attrs.set(attrs.string(), sorted = False), default = None),
            "asset_platforms": attrs.option(attrs.set(attrs.string(), sorted = False), default = None),
            "base_path": attrs.option(attrs.string(), default = None),
            "contacts": attrs.list(attrs.string(), default = []),
            "default_host_platform": attrs.option(attrs.configuration_label(), default = None),
            "deps": attrs.list(attrs.dep(), default = []),
            "deps_query": attrs.option(attrs.query(), default = None),
            "extra_json": attrs.option(attrs.arg(), default = None),
            "labels": attrs.list(attrs.string(), default = []),
            "licenses": attrs.list(attrs.source(), default = []),
            "srcs": attrs.list(attrs.one_of(attrs.source(), attrs.tuple(attrs.source(), attrs.string())), default = []),
            "worker": attrs.dep(),
        }
    ),
)

js_rules = struct(
    js_bundle = js_bundle,
    js_bundle_genrule = js_bundle_genrule,
    js_library = js_library,
)
