# Copyright (c) Meta Platforms, Inc. and affiliates.
#
# This source code is licensed under both the MIT license found in the
# LICENSE-MIT file in the root directory of this source tree and the Apache
# License, Version 2.0 found in the LICENSE-APACHE file in the root directory
# of this source tree.

# TODO(cjhopman): This was generated by scripts/hacks/rules_shim_with_docs.py,
# but should be manually edited going forward. There may be some errors in
# the generated docs, and so those should be verified to be accurate and
# well-formatted (and then delete this TODO)

PythonBuckConfigPackageStyle = ["standalone", "inplace", "inplace_lite"]

def _srcs_arg():
    return {
        "srcs": attrs.named_set(attrs.source(), sorted = True, default = [], doc = """
    The set of Python (`.py`) files to include in this library.
"""),
    }

def _platform_srcs_arg():
    return {
        "platform_srcs": attrs.list(attrs.tuple(attrs.regex(), attrs.named_set(attrs.source(), sorted = True)), default = [], doc = """
    Python-platform-specific source files. These should be specified as a
     list of pairs where the first element in each pair is an un-anchored
     regex against which the platform name is matched, and the second element
     is a list of source files. The regex should use `java.util.regex.Pattern` syntax.
     The platform name is a Python platform *flavor* defined in
     the buckconfig#`python`section of `.buckconfig`.
"""),
    }

def _resources_arg():
    return {
        "resources": attrs.named_set(attrs.source(), sorted = True, default = [], doc = """
    Static files to be packaged along with the Python sources.
     These resources can be accessed at runtime using
     the [pkg\\_resources](http://setuptools.readthedocs.io/en/latest/pkg_resources.html) module distributed
     with Python's setuptools.
"""),
    }

def _platform_resources_arg():
    return {
        "platform_resources": attrs.list(attrs.tuple(attrs.regex(), attrs.named_set(attrs.source(), sorted = True)), default = [], doc = """
    Python-platform-specific resource files. These should be specified as a
     list of pairs where the first element in each pair is an un-anchored
     regex against which the platform name is matched, and the second element
     is a list of resource files. The regex should use `java.util.regex.Pattern` syntax.
     The platform name is a Python platform *flavor* defined in
     the buckconfig#`python`section of `.buckconfig`.
"""),
    }

def _base_module_arg():
    return {
        "base_module": attrs.option(attrs.string(), default = None, doc = """
    The package in which the specified source files and resources should reside in their final
     location in the top-level binary. If unset, Buck uses the project-relative directory
     that contains the BUCK file.
"""),
    }

def _platform_arg():
    return {
        "platform": attrs.option(attrs.string(), default = None, doc = """
    The name of the Python platform *flavor* to build against by default as defined in
     the buckconfig#`python`section of `.buckconfig`.
"""),
    }

def _linker_flags_arg():
    return {
        "linker_flags": attrs.list(attrs.arg(anon_target_compatible = True), default = [], doc = """
    Additional linker flags that should be applied to any linking which is specific to this rule.
     Note that whether these flags are used is dependent on the native link strategy selected in
     `.buckconfig` and currently applies only to the `merged` ``.buckconfig``;
     the `separate` link strategy pulls in shared libraries that are linked in the
     context of the rules that own them, such as `cxx\\_library()`.
"""),
    }

def _package_style_arg():
    return {
        "package_style": attrs.option(attrs.enum(PythonBuckConfigPackageStyle), default = None, doc = """
    Used to override the global packaging style that is set in `[`.buckconfig`
    ]`.
"""),
    }

def _preload_deps_arg():
    return {
        "preload_deps": attrs.list(attrs.dep(), default = [], doc = """
    A list of C/C++ library dependencies that need to be loaded before any
     other libraries when the PEX starts up. This requires dynamic loader support,
     such as `LD_PRELOAD`, found on most systems. This list is order-
     sensitive and the preload libraries listed here are passed down to the dynamic
     linker in the same order.
"""),
    }

def _exclude_deps_from_merged_linking_arg():
    return {
        "exclude_deps_from_merged_linking": attrs.bool(default = False, doc = """
    When linking the top-level binary with a `merged` ``.buckconfig``,
     do not merge or re-link any native transitive deps of this library. This is useful if
     this library wraps prebuilt native extensions which cannot be re-linked as part of
     library merging.
"""),
    }

def _deduplicate_merged_link_roots():
    return {
        "deduplicate_merged_link_roots": attrs.option(attrs.bool(), default = None, doc = """
    When linking multiple top-level binaries with the `merged` ``.buckconfig``,
     coalesce root link rules which are identical across independent merged links.
"""),
    }

python_common = struct(
    srcs_arg = _srcs_arg,
    platform_srcs_arg = _platform_srcs_arg,
    resources_arg = _resources_arg,
    platform_resources_arg = _platform_resources_arg,
    base_module_arg = _base_module_arg,
    platform_arg = _platform_arg,
    linker_flags_arg = _linker_flags_arg,
    package_style_arg = _package_style_arg,
    preload_deps_arg = _preload_deps_arg,
    exclude_deps_from_merged_linking_arg = _exclude_deps_from_merged_linking_arg,
    deduplicate_merged_link_roots = _deduplicate_merged_link_roots,
)
