# Copyright (c) Meta Platforms, Inc. and affiliates.
#
# This source code is licensed under both the MIT license found in the
# LICENSE-MIT file in the root directory of this source tree and the Apache
# License, Version 2.0 found in the LICENSE-APACHE file in the root directory
# of this source tree.

# TODO(cjhopman): This was generated by scripts/hacks/rules_shim_with_docs.py,
# but should be manually edited going forward. There may be some errors in
# the generated docs, and so those should be verified to be accurate and
# well-formatted (and then delete this TODO)

load(":common.bzl", "validate_uri")

def _name_arg(name_type):
    return {
        "name": name_type,
    }

def _sha256_arg():
    return {
        "sha256": attrs.option(attrs.string(), default = None, doc = """
    The [`SHA-256`](//wikipedia.org/wiki/SHA-2) hash of the downloaded artifact.
     Buck verifies this is correct and fails the fetch command if it doesn't match in order to
     guarantee repeatable builds.
"""),
    }

def _urls_arg():
    return {
        "urls": attrs.list(attrs.string(validate = validate_uri), default = [], doc = """
    A list of urls to attempt to download from. They are tried in order, and
     subsequent ones are only tried if the download fails. If validation fails,
     a new URL is not used. Supported protocols are "http", "https", and "mvn".
"""),
        "vpnless_urls": attrs.list(attrs.string(), default = [], doc = """
    Additional URLs from which this resource can be downloaded when
     off VPN. Meta-internal only.
"""),
    }

remote_common = struct(
    name_arg = _name_arg,
    sha256_arg = _sha256_arg,
    urls_arg = _urls_arg,
)
