//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// <locale>

// class num_put<charT, OutputIterator>

// iter_type put(iter_type s, ios_base& iob, char_type fill, long double v) const;

// XFAIL: win32-broken-printf-g-precision

#include <locale>
#include <ios>
#include <cassert>
#include <streambuf>
#include <cmath>
#include "test_macros.h"
#include "test_iterators.h"

typedef std::num_put<char, cpp17_output_iterator<char*> > F;

class my_facet
    : public F
{
public:
    explicit my_facet(std::size_t refs = 0)
        : F(refs) {}
};

class my_numpunct
    : public std::numpunct<char>
{
public:
    my_numpunct() : std::numpunct<char>() {}

protected:
    virtual char_type do_decimal_point() const {return ';';}
    virtual char_type do_thousands_sep() const {return '_';}
    virtual std::string do_grouping() const {return std::string("\1\2\3");}
};

void test1()
{
    char str[200];
    std::locale lc = std::locale::classic();
    std::locale lg(lc, new my_numpunct);
    const my_facet f(1);
    {
        long double v = +0.;
        std::ios ios(0);
        // %g
        {
            ios.precision(0);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(1);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(6);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.00000******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******************0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******************0.00000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;00000******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******************0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******************0;00000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************+0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*****************0.00000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************+0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*****************0;00000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.00000******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******************0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******************0.00000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;00000******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******************0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******************0;00000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************+0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*****************0.00000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************+0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*****************0;00000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(16);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000000000000********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000000000000********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******+0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*******0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******+0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*******0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000000000000********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000000000000********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******+0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*******0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******+0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*******0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(60);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

void test2()
{
    char str[200];
    std::locale lc = std::locale::classic();
    std::locale lg(lc, new my_numpunct);
    const my_facet f(1);
    {
        long double v = -0.;
        std::ios ios(0);
        // %g
        {
            ios.precision(0);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(1);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(6);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************-0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*****************0.00000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************-0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*****************0;00000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************-0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*****************0.00000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************-0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*****************0;00000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************-0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*****************0.00000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************-0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*****************0;00000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************-0.00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*****************0.00000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************-0;00000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*****************0;00000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(16);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******-0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*******0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******-0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*******0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******-0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*******0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******-0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*******0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******-0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*******0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******-0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*******0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******-0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*******0.000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******-0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*******0;000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(60);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;00000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

void test3()
{
    char str[200];
    std::locale lc = std::locale::classic();
    std::locale lg(lc, new my_numpunct);
    const my_facet f(1);
    {
        long double v = 1234567890.125;
        std::ios ios(0);
        // %g
        {
            ios.precision(0);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1e+09********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********************1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********************1e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1e+09********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********************1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********************1e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1.e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1.e+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************1.e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************1.e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1;e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1;e+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************1;e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************1;e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1e+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************+1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*******************1e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1e+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************+1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*******************1e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1.e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1.e+09******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******************+1.e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+******************1.e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1;e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1;e+09******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******************+1;e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+******************1;e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1E+09********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********************1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********************1E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1E+09********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********************1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********************1E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1.E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1.E+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************1.E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************1.E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1;E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1;E+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************1;E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************1;E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1E+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************+1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*******************1E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1E+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************+1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*******************1E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1.E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1.E+09******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******************+1.E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+******************1.E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1;E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1;E+09******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******************+1;E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+******************1;E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(1);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1e+09********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********************1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********************1e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1e+09********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********************1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********************1e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1.e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1.e+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************1.e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************1.e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1;e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1;e+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************1;e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************1;e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1e+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************+1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*******************1e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1e+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************+1e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*******************1e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1.e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1.e+09******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******************+1.e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+******************1.e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1;e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1;e+09******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******************+1;e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+******************1;e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1E+09********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********************1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********************1E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1E+09********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********************1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********************1E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1.E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1.E+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************1.E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************1.E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1;E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1;E+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************1;E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************1;E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1E+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************+1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*******************1E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1E+09*******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******************+1E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*******************1E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1.E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1.E+09******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******************+1.E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+******************1.E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1;E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1;E+09******************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******************+1;E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+******************1;E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(6);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1.23457e+09**************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**************1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**************1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1;23457e+09**************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**************1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**************1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1.23457e+09**************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**************1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**************1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1;23457e+09**************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**************1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**************1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1.23457e+09*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*************+1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*************1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1;23457e+09*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*************+1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*************1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1.23457e+09*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*************+1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*************1.23457e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1;23457e+09*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*************+1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*************1;23457e+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1.23457E+09**************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**************1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**************1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1;23457E+09**************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**************1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**************1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1.23457E+09**************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**************1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**************1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1;23457E+09**************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**************1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**************1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1.23457E+09*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*************+1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*************1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1;23457E+09*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*************+1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*************1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1.23457E+09*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*************+1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*************1.23457E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1;23457E+09*************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*************+1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*************1;23457E+09");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(16);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1234567890.125***********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1_234_567_89_0;125*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1234567890.125000********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1_234_567_89_0;125000****");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1234567890.125**********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********+1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+**********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1_234_567_89_0;125******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******+1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1234567890.125000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******+1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*******1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1_234_567_89_0;125000***");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***+1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1234567890.125***********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1_234_567_89_0;125*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1234567890.125000********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "********1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1_234_567_89_0;125000****");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1234567890.125**********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********+1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+**********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1_234_567_89_0;125******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******+1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1234567890.125000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******+1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*******1234567890.125000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1_234_567_89_0;125000***");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***+1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***1_234_567_89_0;125000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(60);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1234567890.125***********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1_234_567_89_0;125*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1234567890.125**********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********+1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+**********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1_234_567_89_0;125******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******+1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1234567890.125***********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1_234_567_89_0;125*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1234567890.125**********");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********+1234567890.125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+**********1234567890.125");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1_234_567_89_0;125******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******+1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+******1_234_567_89_0;125");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1234567890.12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+1_234_567_89_0;12500000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

void test4()
{
    char str[200];
    std::locale lc = std::locale::classic();
    std::locale lg(lc, new my_numpunct);
#ifdef _AIX
    std::string inf = "INF";
#else
    std::string inf = "inf";
#endif

    const my_facet f(1);
    {
        long double v = -INFINITY;
        std::ios ios(0);
        // %g
        {
            ios.precision(0);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(1);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(6);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-" + inf + "*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-" + inf);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************" + inf);
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-INF*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-INF");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************INF");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(16);
            {}
            ios.precision(60);
            {}
        }
    }
}

void test5()
{
    char str[200];
    std::locale lc = std::locale::classic();
    std::locale lg(lc, new my_numpunct);
    const my_facet f(1);
#if defined(_AIX)
    std::string nan= "NaNQ";
    std::string NaN = "NaNQ";
    std::string nan_padding25 = "*********************";
    std::string pnan_sign = "+";
    std::string pnan_padding25 = "********************";
#else
    std::string nan= "nan";
    std::string NaN = "NAN";
    std::string nan_padding25 = "**********************";
#if defined(TEST_HAS_GLIBC) || defined(_WIN32) || \
        (defined(__BIONIC__) && !defined(_LIBCPP_TESTING_ANDROID_PRINTF_NAN_NO_SIGN))
    std::string pnan_sign = "+";
    std::string pnan_padding25 = "*********************";
#else
    std::string pnan_sign = "";
    std::string pnan_padding25 = "**********************";
#endif
#endif
    {
        long double v = std::nan("");
        std::ios ios(0);
        // %g
        {
            ios.precision(0);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan + nan_padding25);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan_padding25 + nan);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan_padding25 + nan);
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan + nan_padding25);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan_padding25 + nan);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan_padding25 + nan);
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan + nan_padding25);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan_padding25 + nan);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan_padding25 + nan);
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan + nan_padding25);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan_padding25 + nan);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan_padding25 + nan);
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + nan);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + nan + pnan_padding25);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_padding25 + pnan_sign + nan);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + pnan_padding25 + nan);
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + nan);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + nan + pnan_padding25);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_padding25 + pnan_sign + nan);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + pnan_padding25 + nan);
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + nan);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + nan + pnan_padding25);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_padding25 + pnan_sign + nan);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + pnan_padding25 + nan);
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + nan);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + nan + pnan_padding25);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_padding25 + pnan_sign + nan);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + pnan_padding25 + nan);
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == NaN);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == NaN + nan_padding25);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan_padding25 + NaN);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan_padding25 + NaN);
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == NaN);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == NaN + nan_padding25);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan_padding25 + NaN);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan_padding25 + NaN);
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == NaN);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == NaN + nan_padding25);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan_padding25 + NaN);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan_padding25 + NaN);
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == NaN);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == NaN + nan_padding25);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan_padding25 + NaN);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == nan_padding25 + NaN);
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + NaN);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + NaN + pnan_padding25);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_padding25 + pnan_sign + NaN);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + pnan_padding25 + NaN);
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + NaN);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + NaN + pnan_padding25);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_padding25 + pnan_sign + NaN);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + pnan_padding25 + NaN);
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + NaN);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + NaN + pnan_padding25);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_padding25 + pnan_sign + NaN);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + pnan_padding25 + NaN);
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + NaN);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + NaN + pnan_padding25);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_padding25 + pnan_sign + NaN);
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == pnan_sign + pnan_padding25 + NaN);
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(1);
            {}
            ios.precision(6);
            {}
            ios.precision(16);
            {}
            ios.precision(60);
            {}
        }
    }
}

void test6()
{
    char str[200];
    std::locale lc = std::locale::classic();
    std::locale lg(lc, new my_numpunct);
    const my_facet f(1);
    {
        long double v = +0.;
        std::ios ios(0);
        std::fixed(ios);
        // %f
        {
            ios.precision(0);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0************************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "************************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************+0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************+0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************+0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(1);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.0**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;0**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.0**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;0**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************+0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************+0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************+0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************+0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.0**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;0**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.0**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;0**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************+0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************+0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************+0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************+0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(6);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************+0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************+0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************+0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************+0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000*****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************+0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************+0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************+0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************+0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(16);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.0000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;0000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.0000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;0000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******+0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******+0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******+0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******+0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.0000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;0000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.0000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;0000000000000000*******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******+0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******+0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******+0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******+0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(60);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "+0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

void test7()
{
    char str[200];
    std::locale lc = std::locale::classic();
    std::locale lg(lc, new my_numpunct);
    const my_facet f(1);
    {
        long double v = -0.;
        std::ios ios(0);
        std::fixed(ios);
        // %f
        {
            ios.precision(0);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0***********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "***********************-0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-***********************0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0.");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0.");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;**********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "**********************-0;");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-**********************0;");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(1);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-0.0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************0.0");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0*********************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "*********************-0;0");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-*********************0;0");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(6);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************-0.000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-****************0.000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000****************");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "****************-0;000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-****************0;000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(16);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******-0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-******0.0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;0000000000000000******");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "******-0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-******0;0000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
            ios.precision(60);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
                std::uppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                    std::showpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                        std::showpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0.000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                            ios.imbue(lg);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::left(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::right(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                                ios.width(25);
                                std::internal(ios);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char*>(str), ios, '*', v);
                                    std::string ex(str, base(iter));
                                    assert(ex == "-0;000000000000000000000000000000000000000000000000000000000000");
                                    assert(ios.width() == 0);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

void test8()
{
    char str[200];
    std::locale lc = std::locale::classic();
    std::locale lg(lc, new my_numpunct);
    const my_facet f(1);
    {
        long double v = 1234567890.125;
        std::ios ios(0);
        std::fixed(ios);
        // %f
        {
            ios.precision(0);
            {
                std::nouppercase(ios);
                {
                    std::noshowpos(ios);
                    {
                        std::noshowpoint(ios);
                        {
                            ios.imbue(lc);
                            {
                                ios.width(0);
                                {
                                    cpp17_output_iterator<char*> iter = f.put(cpp17_output_iterator<char