#!/system/bin/sh
# Do NOT assume where your module will be located.
# ALWAYS use $MODDIR if you need to know where this script
# and module is placed.
# This will make sure your module will still work
# if Magisk change its mount point in the future
MODDIR=${0%/*}

# This script will be executed in post-fs-data mode

# Find All device touchscreen
TOUCH_DEVS=$(ls /sys/class/input/input*/name | xargs grep -l "touch" | sed 's/name//')

# Set parameter low-latency
for dev in $TOUCH_DEVS; do
    # Turbo Report Rate (1000Hz)
    echo 1000 > $dev/report_rate 2>/dev/null
    echo 0 > $dev/filter_size 2>/dev/null
    echo 0 > $dev/jitter 2>/dev/null
    
    # Game Mode Activation
    echo 1 > $dev/game_mode_enabled 2>/dev/null
    echo 0 > $dev/palm_rejection 2>/dev/null
    
    # Latency Reduction
    echo 1 > $dev/raw_mode 2>/dev/null
    echo 99 > $dev/priority 2>/dev/null
done
