#!/system/bin/sh
# Do NOT assume where your module will be located.
# ALWAYS use $MODDIR if you need to know where this script
# and module is placed.
# This will make sure your module will still work
# if Magisk change its mount point in the future
MODDIR=${0%/*}
# Touch Tweak
# Inisialisasi Menunggu sampai sys.boot_completed memiliki nilai yang tidak kosong
while [ -z "$(resetprop sys.boot_completed)" ]; do
  sleep 5
done

sleep 20

#Latency Tracker OFF
cmd device_config put latency_tracker enabled false
cmd device_config put latency_tracker sampling_interval 9999999999999999
# Interaction Jank Monitor OFF
cmd device_config put interaction_jank_monitor enabled false
cmd device_config put interaction_jank_monitor sampling_interval 9999999999999999
cmd device_config put perfetto tracing_enabled false

# === INPUT LATENCY & DISPATCH ===
device_config put input max_event_latency_ms 0
device_config put input dispatcher_low_latency true

# === POINTER HANDLING ===
device_config put input pointer_prediction_enabled true
device_config put input pointer_velocity_filter_enabled true
device_config put input pointer_resampling_filter_enabled false

# === THERMAL SAFE INPUT ===
settings put secure thermal_safety_mode 1
cmd device_config put activity_manager fixed_renew_buf_on_input true

# === INPUT PIPELINE SPEED ===
device_config put input input_event_timeout_ms 12
device_config put input input_dispatch_resolution_ns 1000000

# === VSYNC SYNC KE TOUCH ===
settings put global vsync_frame_interval 8333333
settings put global vsync_event_phase_offset_ns 0
settings put global sf_phase_offset_ns 0

# === POWERHAL TOUCH BOOST ===
cmd device_config put powerhal touch_boost_enabled true
cmd device_config put powerhal launch_boost_enabled true

# === BYPASS ANIM DELAY ===
device_config put input ignore_window_animation_delay true

# Overclock Touch Sample & Refresh Rate
device_config put input native_boost_touch_input true
device_config put input boost_touch_dispatcher true
device_config put input filtered_accel_event_rate_hz 1000
device_config put input touch_sample_rate_hz 1000
device_config put input touch_resample_enabled true
device_config put input touch_screen_sample_interval_ms 0
device_config put input latency_mode low
device_config put input max_touch_move_duration_ms 0
device_config put input tap_duration 0
device_config put input input_boost_duration_ms 0

device_config put surfaceflinger refresh_rate 240
device_config put surfaceflinger max_frame_buffer_acquired_count 1
device_config put surfaceflinger frame_rate_multiple_threshold 0
device_config put surfaceflinger max_frame_rate 240
device_config put surfaceflinger min_frame_rate 240
device_config put surfaceflinger peak_frame_rate 240
device_config put surfaceflinger enable_refresh_rate_overlay false
device_config put surfaceflinger set_max_frame_rate_multiplier 1.0

device_config put systemui accelerate_refresh_rate true
device_config put systemui min_refresh_rate_for_fps_boost 240
device_config put systemui max_refresh_rate_for_fps_boost 240

device_config put scheduler boost_display_refresh true
device_config put display dynamic_refresh_rate_enabled false
device_config put display enable_frame_rate_boosting true
device_config put activity_manager force_high_refresh_rate true

# Mengatur skala animasi untuk respons lebih cepat
settings put global window_animation_scale 0.25
settings put global transition_animation_scale 0.25
settings put global animator_duration_scale 0.25

# Ultra Touch
echo 500 > $dev/report_rate 2>/dev/null
echo 0 > $dev/filter_size 2>/dev/null
echo 0 > $dev/jitter 2>/dev/null

# Optimasi sentuhan
settings put system tap_duration 20
settings put system view.scroll_friction 3
settings put secure pointer_speed 10

# Simulasi input untuk meningkatkan stabilitas sentuhan
input gamepad swipe 200 500 600 500 30
input touchpad swipe 200 500 300 500 70
input touchscreen swipe 100 100 500 500 150
input swipe 500 1000 900 1000 30
input gamepad tap 250 450
input touchpad tap 350 650
input touchscreen tap 130 180
input tap 750 1150

# Tweak jaringan
sysctl -w net.core.busy_read=50
sysctl -w net.core.busy_poll=50

#Set Touch Poling Rate 
echo 240 > /sys/devices/virtual/input/input1/polling_rate
su -c settings put global touch_sampling_rate 240

# Pastikan perubahan diterapkan
echo 50 > /proc/sys/net/core/busy_read
echo 50 > /proc/sys/net/core/busy_poll
echo 10000000 > /proc/sys/kernel/sched_latency_ns
echo 1000000 > /proc/sys/kernel/sched_min_granularity_ns
echo 2000000 > /proc/sys/kernel/sched_wakeup_granularity_ns

#Cmd Config Touch 
cmd device_config put input default_key_press_repeat_rate 33
cmd device_config put input filtered_accel_event_rate_hz 240
cmd device_config put input touch_screen_sample_interval_ms 8
cmd device_config put systemui cg_frame_interval_millis 4
cmd device_config put systemui low_power_refresh_rate_millis 0
cmd device_config put systemui low_power_refresh_rate_millis 0
cmd device_config put systemui cg_max_frame_skip 8

if [ -f "/proc/perfmgr/tchbst/user/usrtch" ]; then
        echo "eas_boost 100" > /proc/perfmgr/tchbst/user/usrtch
        echo "touch_opp 15" >> /proc/perfmgr/tchbst/user/usrtch
        echo "duration 2000000000" >> /proc/perfmgr/tchbst/user/usrtch
        echo "active_time 1000000" >> /proc/perfmgr/tchbst/user/usrtch
        echo "time_to_last_touch 0" >> /proc/perfmgr/tchbst/user/usrtch
        echo "deboost_when_render 1" >> /proc/perfmgr/tchbst/user/usrtch
        echo "cluster_opp 0 15" >> /proc/perfmgr/tchbst/user/usrtch
        echo "cluster_opp 1 15" >> /proc/perfmgr/tchbst/user/usrtch
    fi
#cr atlantis
change_task_cgroup "system_server" "top-app" "cpuset"
change_task_cgroup "system_server" "foreground" "stune"
resetprop -n windows.mgr.max_event_per_sec 180
resetprop -n ro.min_pointer_dur 8 
resetprop -n ro.max.fling_velocity 12000
resetprop -n ro.min.fling_velocity 8000
resetprop -n view.scroll_friction 10
settings put global block_untrusted_touches 0

# Konfigurasi Kinerja
echo "1" > /sys/module/msm_performance/parameters/touchboost
echo "1" > /sys/power/pnpmgr/touch_boost
echo "always_on" > /sys/devices/platform/13040000.mali/power_policy
echo "always_on" > /sys/devices/platform/13040000.mali/gpuinfo
echo "always_support" > /sys/devices/system/cpu/cpufreq/policy4/scaling_setspeed
echo "always_support" > /sys/devices/system/cpu/cpufreq/policy6/scaling_setspeed

# Konfigurasi Penjadwalan CPU
echo "1" > /sys/devices/system/cpu/sched/cpu_prefer
echo "boost" > /sys/devices/system/cpu/sched/sched_boost
echo "1" > /sys/devices/system/cpu/eas/enable

# Konfigurasi Layar Sentuh
echo "7035" > /sys/class/touch/switch/set_touchscreen
echo "8002" > /sys/class/touch/switch/set_touchscreen
echo "11000" > /sys/class/touch/switch/set_touchscreen
echo "13060" > /sys/class/touch/switch/set_touchscreen
echo "14005" > /sys/class/touch/switch/set_touchscreen

# Konfigurasi Animasi
su -c "settings put global transition_animation_scale 0.0"
su -c "settings put secure multi_press_timeout 50"
su -c "settings put secure long_press_timeout 95"
su -c "settings put global animator_duration_scale 0.0"
su -c "settings put global window_animation_scale 0.0"
su -c "settings put global block_untrusted_touches 0.0"
su -c "settings put global pointer_speed 0.5"

# Konfigurasi Layar Sentuh
# Mengaktifkan fitur game switch, mengatur arah layar sentuh, dan menonaktifkan batasan layar sentuh
echo "1" > /proc/touchpanel/game_switch_enable
echo "1" > /proc/touchpanel/oppo_tp_direction
echo "0" > /proc/touchpanel/oppo_tp_limit_enable
echo "0" > /proc/touchpanel/oplus_tp_limit_enable
echo "1" > /proc/touchpanel/oplus_tp_direction

####################################
# Touchboost
####################################
echo '0' > "/sys/module/msm_perfmon/parameters/touch_boost_enable"
echo '0' > "/sys/module/msm_perfmon/parameters/touch_boost_freq"
echo '0' > "/sys/module/msm_performance/parameters/touchboost"
echo '0' > "/sys/power/pnpmgr/touch_boost"

exit 0




